/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.BusinessHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class DepositApplyUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("tradechannel");
        selector.add("bebankstatus");
        selector.add("applytype");
        selector.add("deposit");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendData : dataEntity) {
            String depositBizStat;
            DynamicObject depositApplyBill = extendData.getDataEntity();
            String checkTargetBillsMsg = BusinessHelper.checkTargetBillsExcludeSaveStat((String)depositApplyBill.getDataEntityType().getName(), (Long)depositApplyBill.getLong("id"));
            if (StringUtils.isNotBlank((CharSequence)checkTargetBillsMsg)) {
                this.addErrorMessage(extendData, checkTargetBillsMsg);
            }
            String tradeChannel = depositApplyBill.getString("tradechannel");
            String beBankStat = depositApplyBill.getString("bebankstatus");
            if (TradeChannelEnum.ONLINE.getValue().equals(tradeChannel) && EmptyUtil.isNoEmpty((String)beBankStat)) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5df2\u7ecf\u63d0\u4ea4\u94f6\u4f01\u76f4\u8054\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"DepositApplyUnAuditValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (!StringUtils.equals((CharSequence)DepositApplyTypeEnum.SUBSIST.getValue(), (CharSequence)depositApplyBill.getString("applytype")) || !FinServiceStatusEnum.isSubscribeEnd((String)(depositBizStat = Optional.ofNullable(depositApplyBill.getDynamicObject("deposit")).map(r -> r.getString("bizstatus")).orElse("")))) continue;
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u6b3e\u5355\u5b58\u6b3e\u4e1a\u52a1\u72b6\u6001\u4e3a\u5df2\u89e3\u6d3b\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"DepositApplyUnAuditValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

