/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class DepositDealAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("srcdepositno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        this.checkExistsReleaseBill(dataEntitys);
    }

    private void checkExistsReleaseBill(ExtendedDataEntity[] dataEntitys) {
        Map varMap = this.getOption().getVariables();
        if (varMap.containsKey("skipredepositvalidate")) {
            return;
        }
        List depositBills = Arrays.stream(dataEntitys).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map existMap = DepositHelper.isExistsReleaseBill(depositBills);
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            long depositId = dataEntity.getDataEntity().getLong("id");
            if (!((Boolean)existMap.get(depositId)).booleanValue()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7eed\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u5728\u9014\u7684\u89e3\u6d3b\u5355\u3002", (String)"FixedDepositReDepositValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

