/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositDealEndValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedData : dataEntity) {
            DynamicObject depositBill = extendedData.getDataEntity();
            String bizStatus = depositBill.getString("bizstatus");
            if (!FinServiceStatusEnum.isSubscribeNorevenue((String)bizStatus)) {
                this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u975e\u5df2\u89e3\u6d3b\u672a\u6536\u76ca\uff0c\u4e0d\u80fd\u7ed3\u675f\u5b58\u5355\u3002", (String)"DepositDealEndValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            this.validateIsExistsTarDoing(extendedData, depositBill);
        }
    }

    private void validateIsExistsTarDoing(ExtendedDataEntity extData, DynamicObject depositBill) {
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)depositBill.getDynamicObjectType().getName(), (Long[])new Long[]{depositBill.getLong("id")});
        if (EmptyUtil.isEmpty((Object)botpMap)) {
            return;
        }
        for (Map.Entry entry : botpMap.entrySet()) {
            DynamicObject[] targetBills;
            for (DynamicObject targetBill : targetBills = TmcDataServiceHelper.load((String)((String)entry.getKey()), (String)"billstatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())})) {
                if (BillStatusEnum.isAudit((String)targetBill.getString("billstatus"))) continue;
                String entityName = CimEntityEnum.getName((String)targetBill.getDynamicObjectType().getName());
                this.addErrorMessage(extData, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5728\u9014\u7684%1$s\u3010%2$s\u3011\uff0c\u4e0d\u80fd\u7ed3\u675f\u5b58\u5355\u3002", (String)"DepositDealEndValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]), entityName, targetBill.getString("billno")));
            }
        }
    }
}

