/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositDealForMultiApplyValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("apply");
        selector.add("amount");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        boolean skipapplymulvalidate = this.getOption().containsVariable("skipapplymulvalidate");
        if (skipapplymulvalidate) {
            return;
        }
        List dataEntities = Arrays.stream(dataEntity).filter(this::isDeposit).collect(Collectors.toList());
        if (dataEntities.isEmpty()) {
            return;
        }
        List<DynamicObject> depositBills = dataEntities.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map<Long, BigDecimal> depositTotalAmtMap = this.getDepositApplyTotalAmt(depositBills);
        for (ExtendedDataEntity extend : dataEntities) {
            DynamicObject depositBill = extend.getDataEntity();
            BigDecimal totalAmt = depositTotalAmtMap.get(depositBill.getLong("id"));
            if (!EmptyUtil.isNoEmpty((BigDecimal)totalAmt)) continue;
            DynamicObject depositApplySrc = depositBill.getDynamicObject("apply");
            BigDecimal amount = depositBill.getBigDecimal("amount");
            if (totalAmt.add(amount).compareTo(depositApplySrc.getBigDecimal("amount")) <= 0) continue;
            this.addErrorMessage(extend, ResManager.loadKDString((String)"\u672c\u6b21\u5b58\u6b3e\u91d1\u989d\u5927\u4e8e\u5b58\u6b3e\u7533\u8bf7\u5355\u7684\u5269\u4f59\u53ef\u5b58\u6b3e\u91d1\u989d\u3002", (String)"DepositDealForMultiApplyValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private boolean isDeposit(ExtendedDataEntity dataEntity) {
        DynamicObject apply = dataEntity.getDataEntity().getDynamicObject("apply");
        return apply != null && DepositApplyTypeEnum.isDeposit((String)apply.getString("applytype"));
    }

    private Map<Long, BigDecimal> getDepositApplyTotalAmt(List<DynamicObject> depositBills) {
        HashMap<Long, BigDecimal> totalAmtMap = new HashMap<Long, BigDecimal>(depositBills.size());
        Map<Long, List<DynamicObject>> applyMap = depositBills.stream().collect(Collectors.groupingBy(d -> d.getLong("apply.id")));
        if (applyMap.isEmpty()) {
            return totalAmtMap;
        }
        QFilter qFilter = new QFilter("apply", "in", applyMap.keySet());
        DynamicObjectCollection depositCols = QueryServiceHelper.query((String)"cim_deposit", (String)"id,billno,amount,apply.id", (QFilter[])qFilter.toArray());
        Map<Long, List<DynamicObject>> applyBillMap = depositCols.stream().collect(Collectors.groupingBy(d -> d.getLong("apply.id")));
        for (DynamicObject depositBill : depositBills) {
            long applyId = depositBill.getLong("apply.id");
            List<DynamicObject> deposits = applyBillMap.get(applyId);
            if (EmptyUtil.isEmpty(deposits)) continue;
            BigDecimal totalAmt = deposits.stream().filter(d -> !d.getString("billno").equals(depositBill.getString("billno"))).map(d -> d.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalAmtMap.put(depositBill.getLong("id"), totalAmt);
        }
        return totalAmtMap;
    }
}

