/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.BusinessHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class DepositDealUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("bizstatus");
        selector.add("tradechannel");
        selector.add("bebankstatus");
        selector.add("isinit");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        List<ExtendedDataEntity> dataEntities = this.validateBillHead(dataEntitys);
        dataEntities = this.validateReDepositBill(dataEntities);
        dataEntities = this.validateIsApplyUsed(dataEntities);
        this.checkDirtTargetBills(dataEntities);
    }

    private List<ExtendedDataEntity> validateBillHead(ExtendedDataEntity[] dataEntity) {
        ArrayList<ExtendedDataEntity> dataEntities = new ArrayList<ExtendedDataEntity>(dataEntity.length);
        for (ExtendedDataEntity extendData : dataEntity) {
            DynamicObject depositBill = extendData.getDataEntity();
            if (FinServiceStatusEnum.isPledgeIng((String)depositBill.getString("bizstatus"))) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u8d28\u62bc\u4e2d\u7684\u5b58\u6b3e\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"DepositDealUnAuditValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            if (TradeChannelEnum.isOnLine((String)depositBill.getString("tradechannel")) && EmptyUtil.isNoEmpty((String)depositBill.getString("bebankstatus"))) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u63d0\u4ea4\u94f6\u4f01\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"DepositDealUnAuditValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            if (!this.validateWhenCreatedByInit(extendData)) continue;
            dataEntities.add(extendData);
        }
        return dataEntities;
    }

    private List<ExtendedDataEntity> checkDirtTargetBills(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        DynamicObject depositBill = dataEntities.get(0).getDataEntity();
        List billIds = dataEntities.stream().map(d -> d.getDataEntity().getLong("id")).collect(Collectors.toList());
        HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>(16);
        filterMap.put("cas_paybill", new QFilter("billstatus", "!=", (Object)"G"));
        filterMap.put("cas_recbill", new QFilter("billstatus", "!=", (Object)"A"));
        Map msgMap = BusinessHelper.checkDirtTargetBills((String)depositBill.getDataEntityType().getName(), billIds, filterMap);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long billId = dataEntity.getDataEntity().getLong("id");
            String msg = (String)msgMap.get(billId);
            if (EmptyUtil.isNoEmpty((String)msg)) {
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateReDepositBill(List<ExtendedDataEntity> extendDatas) {
        if (EmptyUtil.isEmpty(extendDatas)) {
            return extendDatas;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(extendDatas.size());
        Map<Long, ExtendedDataEntity> dataEntityMap = extendDatas.stream().collect(Collectors.toMap(d -> d.getDataEntity().getLong("id"), d -> d));
        QFilter qFilter = new QFilter("srcdepositid", "in", dataEntityMap.keySet()).and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        DynamicObjectCollection reDepositBills = QueryServiceHelper.query((String)"cim_deposit", (String)"id,billno,srcdepositid", (QFilter[])qFilter.toArray());
        Map<Long, List<DynamicObject>> srcDepositMap = reDepositBills.stream().collect(Collectors.groupingBy(d -> d.getLong("srcdepositid")));
        for (ExtendedDataEntity extendData : extendDatas) {
            DynamicObject depositBill = extendData.getDataEntity();
            long depositId = depositBill.getLong("id");
            List<DynamicObject> srcBills = srcDepositMap.get(depositId);
            if (EmptyUtil.isNoEmpty(srcBills)) {
                String billNos = srcBills.stream().map(d -> d.getString("billno")).collect(Collectors.joining(","));
                String entityName = depositBill.getDynamicObjectType().getName();
                this.addErrorMessage(extendData, String.format(ResManager.loadKDString((String)"\u5b58\u5728%1$s\u751f\u6210\u7684\u5355\u636e[%2$s]\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"DepositDealUnAuditValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]), this.getOperateName(entityName), billNos));
                continue;
            }
            dataEntityList.add(extendData);
        }
        return dataEntityList;
    }

    private String getOperateName(String entityName) {
        String operateName = StringUtils.equalsAny((CharSequence)entityName, (CharSequence[])new CharSequence[]{"cim_deposit", "ifm_deposit"}) ? ResManager.loadKDString((String)"\u7eed\u5b58", (String)"DepositDealUnAuditValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]) : (StringUtils.equalsAny((CharSequence)entityName, (CharSequence[])new CharSequence[]{"cim_noticedeposit", "ifm_notice_deposit"}) ? ResManager.loadKDString((String)"\u8f6c\u5b58", (String)"DepositDealUnAuditValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7eed\u671f", (String)"DepositDealUnAuditValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
        return operateName;
    }

    private List<ExtendedDataEntity> validateIsApplyUsed(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        List depositIds = dataEntities.stream().map(d -> d.getDataEntity().getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("deposit", "in", depositIds).and("applytype", "=", (Object)DepositApplyTypeEnum.SUBSIST.getValue());
        DynamicObjectCollection applys = QueryServiceHelper.query((String)"cim_deposit_apply", (String)"deposit", (QFilter[])qFilter.toArray());
        Set ids = applys.stream().map(d -> d.getLong("deposit")).collect(Collectors.toSet());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (ids.contains(dataEntity.getDataEntity().getLong("id"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u88ab\u5b58\u6b3e\u4e1a\u52a1\u7533\u8bf7\u5355\u5f15\u7528\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"DepositDealUnAuditValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private boolean validateWhenCreatedByInit(ExtendedDataEntity extendData) {
        DynamicObject depositBill = extendData.getDataEntity();
        if (depositBill.getBoolean("isinit") && !depositBill.getDynamicObjectType().getName().contains("_init")) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u8bf7\u5728\u5bf9\u5e94\u7684\u5b58\u6b3e\u521d\u59cb\u5316\u83dc\u5355\u5904\u53cd\u5ba1\u6838\u3002", (String)"DepositDealUnAuditValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

