/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositIntSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("billno");
        selector.add("id");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject intPreBill = extData.getDataEntity();
            long depositBillId = intPreBill.getLong("sourcebillid");
            QFilter filter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("id", "!=", intPreBill.getPkValue())).and(new QFilter("sourcebillid", "=", (Object)depositBillId));
            DynamicObjectCollection preBills = QueryServiceHelper.query((String)intPreBill.getDataEntityType().getName(), (String)"billno", (QFilter[])filter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)preBills) && "ifm_depositpreint".equals(intPreBill.getDynamicObjectType().getName())) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5185\u90e8\u5b58\u6b3e\u5355\u5b58\u5728\u5728\u9014\u7684\u9884\u63d0\u5904\u7406\u5355%s\uff0c\u8bf7\u5148\u5ba1\u6838\u6216\u5220\u9664\u3002", (String)"DepositIntSubmitValidator_1", (String)"tmc-cim-business", (Object[])new Object[]{((DynamicObject)preBills.get(0)).getString("billno")}));
            }
            this.validateExistRevenue(extData, depositBillId);
        }
    }

    private void validateExistRevenue(ExtendedDataEntity extData, long depositBillId) {
        QFilter revFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        revFilter.and(new QFilter("sourcebillid", "=", (Object)depositBillId));
        DynamicObjectCollection revBills = QueryServiceHelper.query((String)"cim_dptrevenue", (String)"billno", (QFilter[])new QFilter[]{revFilter}, (String)"");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)revBills)) {
            List revBillList = revBills.stream().map(r -> r.getString("billno")).collect(Collectors.toList());
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5b58\u6b3e\u5355\u5b58\u5728\u5728\u9014\u7684\u6536\u76ca\u5355\u3010%s\u3011\uff0c\u8bf7\u5148\u5ba1\u6838\u6216\u5220\u9664\u3002", (String)"DepositIntSubmitValidator_2", (String)"tmc-cim-business", (Object[])new Object[]{String.join((CharSequence)",", revBillList)}));
        }
    }
}

