/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.helper.PushPayBillVerifyHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositPushPayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("isredepositgenerate");
        selector.add("isinit");
        selector.add("billstatus");
        selector.add("bizstatus");
        selector.add("tradechannel");
        selector.add("bebankstatus");
        selector.add("eassrcid");
        selector.add("accepttransfer");
        selector.add("investvarieties");
        selector.add("transferamount");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Map variables = this.getOption().getVariables();
        String innerAutoPushFlag = (String)variables.get("innerautopushflag");
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject depositBill = extData.getDataEntity();
            String errMsg = PushPayBillVerifyHelper.verifyDepositBill((DynamicObject)depositBill, (BigDecimal)depositBill.getBigDecimal("transferamount"), (String)innerAutoPushFlag);
            if (!EmptyUtil.isNoEmpty((String)errMsg)) continue;
            this.addErrorMessage(extData, errMsg);
        }
    }
}

