/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositReleaseSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("finbillno");
        selector.add("surplusamount");
        selector.add("amount");
        selector.add("lastredeemdate");
        selector.add("redeemdate");
        selector.add("isrevenue");
        selector.add("realrevenue");
        selector.add("redepositamount");
        selector.add("releasetype");
        selector.add("tradechannel");
        selector.add("finorginfo");
        selector.add("rangemin");
        selector.add("rangemax");
        selector.add("interestrate");
        selector.add("accepttransfer");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        List<ExtendedDataEntity> batchDataEntitys = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity extendData : dataEntities) {
            DynamicObject releaseBill = extendData.getDataEntity();
            DynamicObject depositF7 = releaseBill.getDynamicObject("finbillno");
            if (EmptyUtil.isEmpty((DynamicObject)depositF7)) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u6b3e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositReleaseSubmitValidator_9", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            if (!this.validateWhenOpenIsRevenue(extendData, releaseBill, depositF7) || !this.validateRedeemAmount(extendData, releaseBill) || !this.validateRedeemDate(extendData, releaseBill, depositF7) || !this.validateRangeRate(extendData, releaseBill, depositF7)) continue;
            batchDataEntitys.add(extendData);
        }
        batchDataEntitys = this.validateExistsReleaseBill(batchDataEntitys);
        batchDataEntitys = this.validateExistsFailNotReDo(batchDataEntitys);
        batchDataEntitys = this.validateExistsRedepositBill(batchDataEntitys);
    }

    private List<ExtendedDataEntity> validateExistsReleaseBill(List<ExtendedDataEntity> dataEntities) {
        if (dataEntities.isEmpty()) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(1);
        Set depositIds = dataEntities.stream().map(d -> d.getDataEntity().getLong("finbillno.id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("finbillno", "in", depositIds);
        qFilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObjectCollection releaseColl = QueryServiceHelper.query((String)CimEntityEnum.cim_release.getValue(), (String)"id,finbillno.id", (QFilter[])qFilter.toArray());
        Map depositMap = releaseColl.stream().collect(Collectors.groupingBy(d -> d.getLong("finbillno.id"), Collectors.mapping(d -> d.getLong("id"), Collectors.toSet())));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject release = dataEntity.getDataEntity();
            Set releaseIds = depositMap.get(release.getLong("finbillno.id"));
            if (EmptyUtil.isNoEmpty(releaseIds) && (releaseIds.size() > 1 || !releaseIds.contains(release.getLong("id")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u6b3e\u5355\u4e0b\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u89e3\u6d3b\u5355\u8bb0\u5f55\u672a\u5904\u7406\uff0c\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"DepositReleaseSubmitValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateExistsRedepositBill(List<ExtendedDataEntity> dataEntities) {
        if (dataEntities.isEmpty()) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(1);
        List depositBillNos = dataEntities.stream().map(d -> d.getDataEntity().getString("finbillno.number")).collect(Collectors.toList());
        Map map = DepositHelper.isExistsRedepositBill(depositBillNos);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String depositBillNo = dataEntity.getDataEntity().getString("finbillno.number");
            Boolean isTrue = (Boolean)map.get(depositBillNo);
            if (isTrue != null && isTrue.booleanValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u5355\u5b58\u5728\u5728\u9014\u7684\u7eed\u5b58\u5355\uff0c\u8bf7\u5c06\u7eed\u5b58\u5355\u5220\u9664\u540e\u518d\u64cd\u4f5c\u3002", (String)"DepositReleaseSubmitValidator_11", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private boolean validateRedeemAmount(ExtendedDataEntity extendData, DynamicObject releaseBill) {
        BigDecimal surplusAmount = releaseBill.getBigDecimal("surplusamount");
        BigDecimal releaseAmount = releaseBill.getBigDecimal("amount");
        if (releaseAmount.compareTo(surplusAmount) > 0) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u89e3\u6d3b\u91d1\u989d\u4e0d\u5141\u8bb8\u8d85\u8fc7\u53ef\u89e3\u6d3b\u91d1\u989d\u3002", (String)"DepositReleaseSubmitValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateRedeemDate(ExtendedDataEntity extendData, DynamicObject releaseBill, DynamicObject depositF7) {
        Date redeemDate = releaseBill.getDate("redeemdate");
        if (EmptyUtil.isEmpty((Object)redeemDate)) {
            return true;
        }
        Optional.ofNullable(releaseBill.getDate("lastredeemdate")).ifPresent(lastDate -> {
            if (redeemDate.compareTo((Date)lastDate) < 0) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u89e3\u6d3b\u65e5\u671f\u9700\u5927\u4e8e\u6216\u7b49\u4e8e\u4e0a\u6b21\u89e3\u6d3b\u65f6\u95f4\u3002", (String)"DepositReleaseSubmitValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
        });
        if (redeemDate.compareTo(depositF7.getDate("intdate")) < 0) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u89e3\u6d3b\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5b58\u6b3e\u8d77\u606f\u65e5\u3002", (String)"DepositReleaseSubmitValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        Date lastRevenueDate = depositF7.getDate("lastrevenuedate");
        if (EmptyUtil.isNoEmpty((Object)lastRevenueDate) && redeemDate.compareTo(lastRevenueDate) < 0) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u89e3\u6d3b\u65e5\u671f\u9700\u5927\u4e8e\u7b49\u4e8e\u4e0a\u6b21\u6536\u76ca\u65f6\u95f4\u3002", (String)"DepositReleaseSubmitValidator_12", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        if (releaseBill.getBoolean("accepttransfer") && redeemDate.compareTo(depositF7.getDate("expiredate")) >= 0) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5927\u989d\u5b58\u5355\u573a\u666f\u4e0b\u89e3\u6d3b\u65e5\u671f\u9700\u5c0f\u4e8e\u5b58\u6b3e\u5230\u671f\u65e5\u3002", (String)"DepositReleaseSubmitValidator_14", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateWhenOpenIsRevenue(ExtendedDataEntity extendData, DynamicObject releaseBill, DynamicObject depositF7) {
        if (!releaseBill.getBoolean("isrevenue")) {
            return true;
        }
        Date redeemDate = releaseBill.getDate("redeemdate");
        String releaseType = releaseBill.getString("releasetype");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{depositF7, releaseType, redeemDate}) && !releaseBill.getBoolean("accepttransfer") && DepositHelper.judgeUseDemandRate((DynamicObject)depositF7, (String)releaseType, (Date)redeemDate) && EmptyUtil.isEmpty((BigDecimal)releaseBill.getBigDecimal("demandrate"))) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6d3b\u671f\u5229\u7387\uff08%\uff09\u201d\u3002", (String)"DepositReleaseSubmitValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<ExtendedDataEntity> validateExistsFailNotReDo(List<ExtendedDataEntity> dataEntities) {
        if ((dataEntities = dataEntities.stream().filter(d -> TradeChannelEnum.isOnLine((String)d.getDataEntity().getString("tradechannel"))).collect(Collectors.toList())).isEmpty()) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(1);
        Set depositIds = dataEntities.stream().map(d -> d.getDataEntity().getLong("finbillno.id")).collect(Collectors.toSet());
        QFilter beiFilter = new QFilter("finbillno", "in", depositIds);
        beiFilter.and("bebankstatus", "!=", (Object)BebankStatusEnum.TS.getValue());
        beiFilter.and("isresubmit", "!=", (Object)Boolean.TRUE);
        DynamicObjectCollection releaseColl = QueryServiceHelper.query((String)CimEntityEnum.cim_release.getValue(), (String)"id,finbillno.id", (QFilter[])beiFilter.toArray());
        Map depositMap = releaseColl.stream().collect(Collectors.groupingBy(d -> d.getLong("finbillno.id"), Collectors.mapping(d -> d.getLong("id"), Collectors.toSet())));
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject release = extendedDataEntity.getDataEntity();
            Set releaseIds = depositMap.get(release.getLong("finbillno.id"));
            if (EmptyUtil.isNoEmpty(releaseIds) && (releaseIds.size() > 1 || !releaseIds.contains(release.getLong("id")))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5b58\u6b3e\u5355\u4e0b\u5b58\u5728\"\u76f4\u8054\u63d0\u4ea4\u72b6\u6001\"\u4e0d\u7b49\u4e8e\u6210\u529f\u4e14\u672a\u53d1\u8d77\u5931\u8d25\u91cd\u63d0\u7684\u89e3\u6d3b\u5355\uff0c\u8bf7\u5148\u8fdb\u884c\u5931\u8d25\u91cd\u63d0\u3002", (String)"DepositReleaseSubmitValidator_10", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            dataEntityList.add(extendedDataEntity);
        }
        return dataEntityList;
    }

    private boolean validateRangeRate(ExtendedDataEntity extendData, DynamicObject releaseBill, DynamicObject depositF7) {
        if (!InterestTypeEnum.isRange((String)depositF7.getString("interesttype"))) {
            return true;
        }
        BigDecimal rangeMin = releaseBill.getBigDecimal("rangemin");
        BigDecimal rangeMax = releaseBill.getBigDecimal("rangemax");
        BigDecimal interestRate = releaseBill.getBigDecimal("interestrate");
        if (interestRate.compareTo(rangeMin) < 0 || interestRate.compareTo(rangeMax) > 0) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u6b3e\u5229\u7387\u9700\u5728\u5229\u7387\u533a\u95f4\u8303\u56f4\u5185\u3002", (String)"DepositApplySubmitValidator_17", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

