/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class HugeSceneSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("accepttransfer");
        selector.add("investvarieties");
        selector.add("isredepositgenerate");
        selector.add("isinit");
        selector.add("transferertype");
        selector.add("transferdate");
        selector.add("transferrevenue");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject hugeDeposit = extData.getDataEntity();
            if (!hugeDeposit.getBoolean("accepttransfer")) continue;
            String investType = Optional.ofNullable(hugeDeposit.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
            if (!InvestTypeEnum.huge.getValue().equals(investType)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53d7\u8ba9\u5f00\u542f\u65f6\uff0c\u5b58\u6b3e\u54c1\u79cd\u5fc5\u987b\u4e3a\u5927\u989d\u5b58\u5355\u7c7b\u578b\u3002", (String)"HugeSceneSubmitValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (hugeDeposit.getBoolean("isredepositgenerate")) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u7eed\u5b58\u5355\u65f6\uff0c\u53d7\u8ba9\u5f00\u5173\u5fc5\u987b\u4e3a\u5173\u95ed\u72b6\u6001\u3002", (String)"HugeSceneSubmitValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (hugeDeposit.getBoolean("isinit")) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53d7\u8ba9\u5f00\u542f\u65f6\uff0c\u662f\u5426\u521d\u59cb\u5316\u5f00\u5173\u5fc5\u987b\u4e3a\u5173\u95ed\u72b6\u6001\u3002", (String)"HugeSceneSubmitValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            String transferType = hugeDeposit.getString("transferertype");
            Date transferDate = hugeDeposit.getDate("transferdate");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{transferType, transferDate})) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53d7\u8ba9\u5f00\u542f\u65f6\uff0c\u201c\u53d7\u8ba9\u4fe1\u606f\u201d\u9762\u677f\u5fc5\u5f55\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HugeSceneSubmitValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

