/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.NoticeCancelStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class NoticeCancelStatusValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bebankstatus");
        selector.add("iscancel");
        selector.add("cancelstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject noticeRelease;
            DynamicObject apply = extData.getDataEntity();
            String beBankStat = apply.getString("bebankstatus");
            if (!BebankStatusEnum.TS.getValue().equals(beBankStat)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u6709\u64cd\u4f5c\u72b6\u6001\u4e3a\u4ea4\u6613\u6210\u529f\u7684\u8bb0\u5f55\u5141\u8bb8\u64a4\u9500\u3002", (String)"NoticeCancelStatusValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (apply.getBoolean("iscancel") && !NoticeCancelStatusEnum.isFail((String)apply.getString("cancelstatus"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5df2\u7ecf\u64cd\u4f5c\u8fc7\u64a4\u9500\u901a\u77e5\u3002", (String)"NoticeCancelStatusValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(noticeRelease = TmcBotpHelper.getTargetBill((String)"cim_deposit_apply", (Object)apply.getPkValue(), (String)"cim_noticerelease"))) || !EmptyUtil.isNoEmpty((String)noticeRelease.getString("bebankstatus"))) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u89e3\u6d3b\u5355\u5df2\u53d1\u8d77\u8fc7\u652f\u53d6\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u518d\u64a4\u9500\u3002", (String)"NoticeCancelStatusValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

