/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class NoticePushReleaseApplyValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("tradechannel");
        selector.add("bebankstatus");
        selector.add("billno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject notice = extData.getDataEntity();
            String tradeChannel = notice.getString("tradechannel");
            String beBankStat = notice.getString("bebankstatus");
            if (TradeChannelEnum.ONLINE.getValue().equals(tradeChannel) && !BebankStatusEnum.TS.getValue().equals(beBankStat)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u76f4\u8054\u65f6\uff0c\u8bf7\u9009\u62e9\u76f4\u8054\u63d0\u4ea4\u72b6\u6001\u4e3a\u6210\u529f\u7684\u6570\u636e\u3002", (String)"NoticePushReleaseApplyValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            this.validateExistDoingBill(extData, notice);
        }
    }

    private void validateExistDoingBill(ExtendedDataEntity extData, DynamicObject notice) {
        QFilter qFilter = new QFilter("isredepositgenerate", "=", (Object)Boolean.TRUE);
        qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("srcdepositno", "=", (Object)notice.getString("billno")));
        boolean exists = QueryServiceHelper.exists((String)"cim_noticedeposit", (QFilter[])new QFilter[]{qFilter});
        if (exists) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u5355\u5b58\u5728\u5728\u9014\u7684\u8f6c\u5b58\u5355\uff0c\u8bf7\u5c06\u8f6c\u5b58\u5355\u5220\u9664\u540e\u518d\u64cd\u4f5c\u3002", (String)"NoticePushReleaseApplyValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

