/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.dptrevenue;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevBatchSaveOrSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry");
        selector.add("entry.loanbillid");
        selector.add("entry.loanbillno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            Set dbDepSet;
            Set depIdSet;
            DynamicObject revBatch = extData.getDataEntity();
            DynamicObjectCollection entry = revBatch.getDynamicObjectCollection("entry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entry) || EmptyUtil.isEmpty(depIdSet = entry.stream().filter(r -> EmptyUtil.isNoEmpty((Long)r.getLong("loanbillid"))).map(r -> r.getLong("loanbillid")).collect(Collectors.toSet()))) continue;
            QFilter qFilter = new QFilter("id", "!=", revBatch.getPkValue());
            qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
            qFilter.and("entry.loanbillid", "in", depIdSet);
            DynamicObjectCollection cols = QueryServiceHelper.query((String)revBatch.getDynamicObjectType().getName(), (String)"entry.loanbillid loanbillid", (QFilter[])new QFilter[]{qFilter});
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)cols) || EmptyUtil.isEmpty(dbDepSet = cols.stream().filter(r -> EmptyUtil.isNoEmpty((String)"loanbillid")).map(r -> r.getLong("loanbillid")).collect(Collectors.toSet()))) continue;
            depIdSet.retainAll(dbDepSet);
            Map<Long, String> id2BillNoMap = entry.stream().collect(Collectors.toMap(r -> r.getLong("loanbillid"), r -> r.getString("loanbillno")));
            List billNos = depIdSet.stream().map(r -> (String)id2BillNoMap.get(r)).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(billNos)) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5b58\u6b3e\u5355\u3010%s\u3011\u5b58\u5728\u5728\u9014\u7684\u5b58\u6b3e\u6536\u76ca\u6279\u91cf\u5904\u7406\u5355\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"DptRevBatchSaveOrSubmitValidator_1", (String)"tmc-cim-business", (Object[])new Object[]{String.join((CharSequence)",", billNos)}));
        }
    }
}

