/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.dptrevenue;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenuePlanSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("revenue_entry.revenuedate");
        selector.add("revenue_entry.revenuecalamount");
        selector.add("revenue_entry.revenuestate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        HashSet<Date> rowSet = new HashSet<Date>(16);
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject revPlan = extData.getDataEntity();
            DynamicObjectCollection rows = revPlan.getDynamicObjectCollection("revenue_entry");
            for (DynamicObject row : rows) {
                BigDecimal planAmt;
                Date expireDate;
                Date revenueDate = row.getDate("revenuedate");
                if (EmptyUtil.isEmpty((Object)revenueDate)) {
                    this.addErrorMessage(extData, ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DptRevenuePlanSaveValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
                    continue;
                }
                Date intStartDate = revPlan.getDate("intdate");
                if (revenueDate.compareTo(intStartDate) < 0) {
                    this.addErrorMessage(extData, ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5b58\u6b3e\u8d77\u606f\u65e5\u3002", (String)"DptRevenuePlanSaveValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isNoEmpty((Object)(expireDate = revPlan.getDate("expiredate"))) && revenueDate.compareTo(expireDate) > 0) {
                    this.addErrorMessage(extData, ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5230\u671f\u65e5\u3002", (String)"DptRevenuePlanSaveValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (!rowSet.add(revenueDate)) {
                    this.addErrorMessage(extData, ResManager.loadKDString((String)"\u6536\u76ca\u8ba1\u5212\u4fe1\u606f\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u9884\u8ba1\u6536\u76ca\u65e5\u671f\uff0c\u8bf7\u5408\u5e76\u5229\u606f\u6216\u4fee\u6539\u9884\u8ba1\u6536\u76ca\u65e5\u671f\u3002", (String)"DptRevenuePlanSaveValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (!EmptyUtil.isEmpty((BigDecimal)(planAmt = row.getBigDecimal("revenuecalamount")))) continue;
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u6d4b\u7b97\u6536\u76ca\u9700\u5927\u4e8e0\u3002", (String)"DptRevenuePlanSaveValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
        }
    }
}

