/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.dptrevenue;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.helper.PushRecBillVerifyHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenuePush2RecValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("recaccount");
        selector.add("billstatus");
        selector.add("ishistorybuild");
        selector.add("combineinst");
        selector.add("revenuesort");
        selector.add("srcreleaseid");
        selector.add("isinit");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Set<Long> releaseSet = this.getReleaseSet(dataEntity);
        Map opMap = this.getOption().getVariables();
        String innerAutoPushFlag = (String)opMap.get("innerautopushflag");
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject revenue = extData.getDataEntity();
            String errMsg = PushRecBillVerifyHelper.verifyDptRevenueBill((DynamicObject)revenue, (String)innerAutoPushFlag, releaseSet);
            if (!EmptyUtil.isNoEmpty((String)errMsg)) continue;
            this.addErrorMessage(extData, errMsg);
        }
    }

    private Set<Long> getReleaseSet(ExtendedDataEntity[] dataEntity) {
        Set srcReleaseSet = Arrays.stream(dataEntity).map(r -> r.getDataEntity()).filter(r -> RevenueSortEnum.redeem_revenue.getValue().equals(r.getString("revenuesort"))).map(r -> r.getLong("srcreleaseid")).filter(r -> EmptyUtil.isNoEmpty((Long)r)).collect(Collectors.toSet());
        Set<Long> releaseSet = new HashSet<Long>(8);
        if (EmptyUtil.isNoEmpty(srcReleaseSet)) {
            QFilter qFilter = new QFilter("id", "in", srcReleaseSet);
            qFilter.and(new QFilter("accepttransfer", "=", (Object)Boolean.TRUE));
            Object[] releaseBills = TmcDataServiceHelper.load((String)"cim_release", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
            if (EmptyUtil.isNoEmpty((Object[])releaseBills)) {
                releaseSet = Arrays.stream(releaseBills).map(r -> r.getLong("id")).collect(Collectors.toSet());
            }
        }
        return releaseSet;
    }
}

