/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.dptrevenue;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenuePushSettleCenterValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("finorginfo");
        selector.add("billstatus");
        selector.add("confirmstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            this.validateConfirmStatus(extendedDataEntity);
            this.validateSettleType(extendedDataEntity);
            this.validateStatus(extendedDataEntity);
            this.validateDownBill(extendedDataEntity);
            this.validateBizBill(extendedDataEntity);
        }
    }

    private void validateConfirmStatus(ExtendedDataEntity extendedDataEntity) {
        String confirmStatus = extendedDataEntity.getDataEntity().getString("confirmstatus");
        if (!StringUtils.equalsAny((String)confirmStatus, (String[])new String[]{"waitsubmit", "yetreturn"})) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5f85\u63d0\u4ea4\u6216\u5df2\u9000\u56de\u7684\u5b58\u6b3e\u6536\u76ca\u5904\u7406\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DptRevenuePushSettleCenterValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private void validateSettleType(ExtendedDataEntity extendedDataEntity) {
        String type;
        DynamicObject finOrgInfo = extendedDataEntity.getDataEntity().getDynamicObject("finorginfo");
        if (EmptyUtil.isNoEmpty((DynamicObject)finOrgInfo) && !StringUtils.equals((CharSequence)(type = (finOrgInfo = TmcDataServiceHelper.loadSingleFromCache((Object)finOrgInfo.getPkValue(), (String)"bd_finorginfo")).getDynamicObject("finorgtype").getString("type")), (CharSequence)"1")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u6b3e\u673a\u6784\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u7684\u5b58\u6b3e\u6536\u76ca\u5904\u7406\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DptRevenuePushSettleCenterValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private void validateStatus(ExtendedDataEntity extendedDataEntity) {
        String billStatus = extendedDataEntity.getDataEntity().getString("billstatus");
        if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5ba1\u6838\u7684\u5b58\u6b3e\u6536\u76ca\u5904\u7406\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DptRevenuePushSettleCenterValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private void validateDownBill(ExtendedDataEntity extendedDataEntity) {
        String bizStatus;
        Object dptRevenueId = extendedDataEntity.getDataEntity().getPkValue();
        DynamicObject bizDealBill = TmcBotpHelper.getTargetBill((String)"cim_dptrevenue", (Object)dptRevenueId, (String)"ifm_bizdealbill_deposit");
        if (EmptyUtil.isNoEmpty((DynamicObject)bizDealBill) && !StringUtils.equals((CharSequence)(bizStatus = bizDealBill.getString("bizstatus")), (CharSequence)"D")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u6536\u76ca\u5904\u7406\u5355\u5df2\u4e0b\u63a8\u5185\u90e8\u5b58\u6b3e\u53d7\u7406\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DptRevenuePushSettleCenterValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private void validateBizBill(ExtendedDataEntity extendedDataEntity) {
        Object dptRevenueId = extendedDataEntity.getDataEntity().getPkValue();
        DynamicObject dptBill = TmcBotpHelper.getSourceBill((String)"cim_dptrevenue", (Object)dptRevenueId, (String)"cim_deposit");
        if (EmptyUtil.isNoEmpty((DynamicObject)dptBill) && !StringUtils.equalsAny((String)dptBill.getString("bizstatus"), (String[])new String[]{FinServiceStatusEnum.subscribe_done.getValue(), FinServiceStatusEnum.subscribe_part.getValue()})) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5b58\u6b3e\u6216\u5df2\u90e8\u5206\u89e3\u6d3b\u4e1a\u52a1\u72b6\u6001\u7684\u5b9a\u671f\uff08\u901a\u77e5\uff09\u5b58\u6b3e\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DptRevenuePushSettleCenterValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

