/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.dptrevenue;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenueUnSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("revenuesort");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject revenue = extData.getDataEntity();
            Map opMap = this.getOption().getVariables();
            if (EmptyUtil.isNoEmpty((String)((String)opMap.get("fromReleaseAudit")))) continue;
            this.validateIsReleaseRevenue(extData, revenue);
        }
    }

    private void validateIsReleaseRevenue(ExtendedDataEntity extData, DynamicObject revenue) {
        String revenueSort = revenue.getString("revenuesort");
        if (RevenueSortEnum.redeem_revenue.getValue().equals(revenueSort)) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u89e3\u6d3b\u6536\u76ca\u7c7b\u578b\u7684\u6536\u76ca\u5355\u636e\u6b64\u5904\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"DptRevenueUnSubmitValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
        } else if (RevenueSortEnum.redeposit_revenue.getValue().equals(revenueSort)) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u7eed\u5b58\u6536\u76ca\u7c7b\u578b\u7684\u6536\u76ca\u5355\u636e\u6b64\u5904\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"DptRevenueUnSubmitValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

