/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.finsubscribe;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSubscribeAutoRedeemValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("finservicestatus");
        selector.add("expiredate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            Date expireDate;
            DynamicObject finSub = extData.getDataEntity();
            if (!BillStatusEnum.isAudit((String)finSub.getString("billstatus"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5355\u636e\u5141\u8bb8\u4e0b\u63a8\u8d4e\u56de\u5355\u3002", (String)"FinSubscribeAutoRedeemValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            String bizStatus = finSub.getString("finservicestatus");
            if (!FinServiceStatusEnum.subscribe_done.getValue().equals(bizStatus) && !FinServiceStatusEnum.subscribe_part.getValue().equals(bizStatus)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u7533\u8d2d\u6216\u5df2\u90e8\u5206\u8d4e\u56de\u7684\u5355\u636e\u5141\u8bb8\u4e0b\u63a8\u8d4e\u56de\u5355\u3002", (String)"FinSubscribeAutoRedeemValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            QFilter idFilter = new QFilter("finbillno", "=", finSub.getPkValue());
            idFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
            QFilter beBankFilter = new QFilter("finbillno", "=", finSub.getPkValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue()).and("bebankstatus", "not in", (Object)new String[]{BebankStatusEnum.TF.getValue(), BebankStatusEnum.TS.getValue()});
            QFilter qFilter = idFilter.or(beBankFilter);
            boolean existsRed = TmcDataServiceHelper.exists((String)CimEntityEnum.cim_redeem.getValue(), (QFilter[])qFilter.toArray());
            if (existsRed) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u7533\u8d2d\u5355\u4e0b\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u8d4e\u56de\u5355\u8bb0\u5f55\u672a\u5904\u7406\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u8d4e\u56de\u64cd\u4f5c\u3002", (String)"FinSubscribeAutoRedeemValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Object)(expireDate = finSub.getDate("expiredate")))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u7533\u8d2d\u5355\u7684\u7406\u8d22\u5230\u671f\u65e5\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u8d4e\u56de\u64cd\u4f5c\u3002", (String)"FinSubscribeAutoRedeemValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNoEmpty((Object)expireDate) || expireDate.compareTo(DateUtils.getCurrentDate()) == 0) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u81ea\u52a8\u8d4e\u56de\u5931\u8d25\uff0c\u53ea\u6709\u7406\u8d22\u5230\u671f\u65e5\u7b49\u4e8e\u4eca\u65e5\u7684\u7533\u8d2d\u5355\u624d\u80fd\u81ea\u52a8\u8d4e\u56de\u3002", (String)"FinSubscribeAutoRedeemValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

