/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.finsubscribe;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.SuperMarketHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSubscribeSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("redeemway");
        sid.add("buycopies");
        sid.add("iopv");
        sid.add("planrevenue");
        sid.add("intdate");
        sid.add("revenueproject");
        sid.add("sourbillno");
        sid.add("amount");
        sid.add("isrenewal");
        sid.add("product");
        sid.add("finorginfo");
        sid.add("tradechannel");
        sid.add("valuedate");
        sid.add("revenuetype");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        Map<Long, List<ExtendedDataEntity>> map;
        if (dataEntities.length > 1 && !this.checkSumAmount(map = Arrays.stream(dataEntities).collect(Collectors.groupingBy(r -> this.getSourceApplyBill(r.getDataEntity()))))) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject finSubscribe = dataEntity.getDataEntity();
            DynamicObject sourceApplyBill = TmcBotpHelper.getSourceBill((String)"cim_finsubscribe", (Object)finSubscribe.getPkValue(), (String)"cim_finapply");
            if (EmptyUtil.isNoEmpty((DynamicObject)sourceApplyBill) && !finSubscribe.getBoolean("isrenewal")) {
                this.checkAmount(finSubscribe, sourceApplyBill, dataEntity);
            }
            String redeemWay = finSubscribe.getString("redeemway");
            if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
                Date valueDate;
                Date intDate;
                if (EmptyUtil.isEmpty((DynamicObject)finSubscribe.getDynamicObject("revenueproject"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u6536\u76ca\u65b9\u6848\"\u3002", (String)"FinSubscribeSubmitValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((BigDecimal)finSubscribe.getBigDecimal("planrevenue"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u9884\u8ba1\u6536\u76ca\u7387\uff08%\uff09\"\u3002", (String)"FinSubscribeSubmitValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((Object)(intDate = finSubscribe.getDate("intdate")))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u8d77\u606f\u65e5\"\u3002", (String)"FinSubscribeSubmitValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((String)finSubscribe.getString("revenuetype"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u6536\u76ca\u7c7b\u578b\"\u3002", (String)"FinSubscribeSubmitValidator_9", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isNoEmpty((Object)(valueDate = finSubscribe.getDate("valuedate"))) && EmptyUtil.isNoEmpty((Object)intDate) && intDate.compareTo(valueDate) < 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u7406\u8d22\u8d77\u59cb\u65e5\u3002", (String)"FinSubscribeSubmitValidator_12", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
            }
            if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
                if (EmptyUtil.isEmpty((BigDecimal)finSubscribe.getBigDecimal("buycopies"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u8d2d\u4e70\u4efd\u6570\"\u3002", (String)"FinSubscribeSubmitValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((BigDecimal)finSubscribe.getBigDecimal("iopv"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u5355\u4f4d\u51c0\u503c\"\u3002", (String)"FinSubscribeSubmitValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
            }
            this.validateAmountAndProduct(finSubscribe, dataEntity);
            this.validateAmountScale(finSubscribe, dataEntity);
        }
    }

    private boolean checkSumAmount(Map<Long, List<ExtendedDataEntity>> map) {
        for (Map.Entry<Long, List<ExtendedDataEntity>> entry : map.entrySet()) {
            BigDecimal lastAmount;
            if (entry.getKey() == 0L) continue;
            DynamicObject applyBill = TmcDataServiceHelper.loadSingle((Object)entry.getKey(), (String)"cim_finapply", (String)"lastamount,buycopies");
            List<ExtendedDataEntity> subScribeList = entry.getValue();
            BigDecimal sumAmount = subScribeList.stream().map(s -> s.getDataEntity().getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (sumAmount.compareTo(lastAmount = applyBill.getBigDecimal("lastamount")) <= 0) continue;
            for (ExtendedDataEntity dataEntity : subScribeList) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672c\u6b21\u7533\u8d2d\u7d2f\u8ba1\u91d1\u989d\u5927\u4e8e\u7406\u8d22\u7533\u8bf7\u5355\u7684\u5269\u4f59\u53ef\u7533\u8d2d\u91d1\u989d\uff0c\u8bf7\u5355\u4e2a%s\u3002", (String)"FinSubscribeSubmitValidator_8", (String)"tmc-cim-business", (Object[])new Object[]{this.getOperationName()}));
            }
            return false;
        }
        return true;
    }

    private Long getSourceApplyBill(DynamicObject finSubscribe) {
        DynamicObject sourceBill = TmcBotpHelper.getSourceBill((String)"cim_finsubscribe", (Object)finSubscribe.getPkValue(), (String)"cim_finapply");
        if (EmptyUtil.isNoEmpty((DynamicObject)sourceBill)) {
            return sourceBill.getLong("id");
        }
        return 0L;
    }

    private void checkAmount(DynamicObject finSubscribe, DynamicObject sourceApplyBill, ExtendedDataEntity dataEntity) {
        BigDecimal lastAmount = sourceApplyBill.getBigDecimal("lastamount");
        BigDecimal amount = finSubscribe.getBigDecimal("amount");
        if (amount.compareTo(lastAmount) > 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672c\u6b21\u7533\u8d2d\u91d1\u989d\u5927\u4e8e\u7406\u8d22\u7533\u8bf7\u5355\u7684\u5269\u4f59\u53ef\u7533\u8d2d\u91d1\u989d\uff0c\u4e0d\u80fd%s\u3002", (String)"FinSubscribeSubmitValidator_6", (String)"tmc-cim-business", (Object[])new Object[]{this.getOperationName()}));
        }
    }

    private void validateAmountAndProduct(DynamicObject finSubscribe, ExtendedDataEntity dataEntity) {
        DynamicObject product = finSubscribe.getDynamicObject("product");
        if (EmptyUtil.isEmpty((DynamicObject)product)) {
            return;
        }
        List errMsgs = SuperMarketHelper.getValidateProductCardMsgs((DynamicObject)finSubscribe, (String)"");
        if (EmptyUtil.isNoEmpty((Object)errMsgs)) {
            for (String errMsg : errMsgs) {
                this.addErrorMessage(dataEntity, errMsg);
            }
        }
    }

    private void validateAmountScale(DynamicObject finSubscribe, ExtendedDataEntity dataEntity) {
        String tradeChannel = finSubscribe.getString("tradechannel");
        if (!TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
            return;
        }
        BigDecimal amount = finSubscribe.getBigDecimal("amount");
        String amtStr = amount.stripTrailingZeros().toPlainString();
        if (amtStr.indexOf(46) > 0 && amtStr.substring(amtStr.indexOf(46) + 1).length() >= 3) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u65f6\uff0c\u7406\u8d22\u91d1\u989d\u53ea\u80fd\u4fdd\u7559\u4e24\u4f4d\u7cbe\u5ea6\u3002", (String)"FinSubscribeSubmitValidator_11", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

