/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.finsubscribe;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.helper.BusinessHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class FinSubscribeUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("id");
        sid.add("billstatus");
        sid.add("finservicestatus");
        sid.add("bebankstatus");
        sid.add("isresubmit");
        sid.add("isinit");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String checkRev;
            DynamicObject sourceBill;
            boolean isResubmit;
            String beBankStatus;
            DynamicObject finSubscribe = dataEntity.getDataEntity();
            if (FinServiceStatusEnum.pledge_ing.getValue().equals(finSubscribe.getString("finservicestatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d28\u62bc\u4e2d\u7684\u7406\u8d22\u7533\u8d2d\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinSubscribeUnAuditValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((String)(beBankStatus = finSubscribe.getString("bebankstatus")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u94f6\u4f01\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinSubscribeUnAuditValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (isResubmit = finSubscribe.getBoolean("isresubmit")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5931\u8d25\u91cd\u63d0\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinSubscribeUnAuditValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>(16);
            filterMap.put("cas_paybill", new QFilter("billstatus", "!=", (Object)"G"));
            String checkTargetBillsMsg = BusinessHelper.checkDirtTargetBills((String)finSubscribe.getDataEntityType().getName(), (Long)finSubscribe.getLong("id"), filterMap);
            if (StringUtils.isNotBlank((CharSequence)checkTargetBillsMsg)) {
                this.addErrorMessage(dataEntity, checkTargetBillsMsg);
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(sourceBill = TmcBotpHelper.getSourceBill((String)"cim_finsubscribe", (Object)finSubscribe.getPkValue(), (String)"cim_finapply"))) && EmptyUtil.isNoEmpty((String)(checkRev = this.checkIsLastSubscribe(sourceBill, finSubscribe)))) {
                this.addErrorMessage(dataEntity, checkRev);
            }
            QFilter qFilter = new QFilter("entry.finbillid", "=", (Object)finSubscribe.getLong("id"));
            qFilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            boolean exists = TmcDataServiceHelper.exists((String)"cim_intbill_batch", (QFilter[])qFilter.toArray());
            if (exists) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u5728\u9014\u7684\u6279\u91cf\u9884\u63d0\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"IntBillBatchUnAuditValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            this.validateWhenCreatedByInit(dataEntity);
        }
    }

    private String checkIsLastSubscribe(DynamicObject sourceBill, DynamicObject finSubscribe) {
        Long[] targetIds = TmcBotpHelper.getTargetBillIds((String)"cim_finapply", (Object)sourceBill.getPkValue(), (String)"cim_finsubscribe");
        QFilter qFilter = new QFilter("id", "in", (Object)targetIds);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObjectCollection lastSubscribe = QueryServiceHelper.query((String)CimEntityEnum.cim_finsubscribe.getValue(), (String)"id", (QFilter[])qFilter.toArray(), (String)"auditdate desc", (int)1);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)lastSubscribe) && !((DynamicObject)lastSubscribe.get(0)).get("id").equals(finSubscribe.getPkValue())) {
            return ResManager.loadKDString((String)"\u4e0d\u662f\u6700\u540e\u4e00\u7b14\u7533\u8d2d\uff0c\u8bf7\u6309\u7167\u65f6\u95f4\u987a\u5e8f\u53cd\u5ba1\u6838\u3002", (String)"FinSubscribeUnAuditValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]);
        }
        return "";
    }

    private void validateWhenCreatedByInit(ExtendedDataEntity extendData) {
        DynamicObject finSubscribe = extendData.getDataEntity();
        if (finSubscribe.getBoolean("isinit") && !finSubscribe.getDynamicObjectType().getName().contains("_init")) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u8bf7\u5728\u7406\u8d22\u7533\u8d2d\u521d\u59cb\u5316\u83dc\u5355\u5904\u53cd\u5ba1\u6838\u3002", (String)"FinSubscribeUnAuditValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

