/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.init;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class DepositInitSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("handredeemamt");
        selector.add("amount");
        selector.add("intdate");
        selector.add("handendpredate");
        selector.add("handlastrevenuedate");
        selector.add("handrevenueamt");
        selector.add("handlastredeemdate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            BigDecimal handRevenueAmt;
            Date lastRevenueDate;
            Date handRedeemDate;
            DynamicObject initBill = extData.getDataEntity();
            BigDecimal handRedeemAmt = initBill.getBigDecimal("handredeemamt");
            if (DepositHelper.validateHandRedeemAmt((BigDecimal)handRedeemAmt, (BigDecimal)initBill.getBigDecimal("amount"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5df2\u89e3\u6d3b\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5b58\u6b3e\u91d1\u989d\u3002", (String)"DepositInitSubmitValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (DepositHelper.validateHandAmtAndDate((Date)(handRedeemDate = initBill.getDate("handlastredeemdate")), (BigDecimal)handRedeemAmt)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u6700\u540e\u4e00\u6b21\u89e3\u6d3b\u65f6\u95f4\u4e0e\u5df2\u89e3\u6d3b\u91d1\u989d\u8981\u4e48\u540c\u65f6\u4e3a\u7a7a\u8981\u4e48\u540c\u65f6\u4e0d\u4e3a\u7a7a\u3002", (String)"DepositInitSubmitValidator_8", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            Date startDate = initBill.getDate("intdate");
            Date lastPreDate = initBill.getDate("handendpredate");
            if (DepositHelper.validateHandEndPre((Date)lastPreDate, (Date)startDate)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4e0a\u6b21\u9884\u63d0\u7ed3\u675f\u65e5\u5fc5\u987b\u5927\u4e8e\u5b58\u6b3e\u8d77\u606f\u65e5\u3002", (String)"DepositInitSubmitValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (DepositHelper.validateHandLastRev((Date)(lastRevenueDate = initBill.getDate("handlastrevenuedate")), (Date)startDate)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4e0a\u6b21\u6536\u76ca\u65e5\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5b58\u6b3e\u8d77\u606f\u65e5\u3002", (String)"DepositInitSubmitValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (DepositHelper.validateHandAmtAndDate((Date)lastRevenueDate, (BigDecimal)(handRevenueAmt = initBill.getBigDecimal("handrevenueamt")))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4e0a\u6b21\u6536\u76ca\u65e5\u4e0e\u5df2\u6536\u76ca\u91d1\u989d\u8981\u4e48\u540c\u65f6\u4e3a\u7a7a\u8981\u4e48\u540c\u65f6\u4e0d\u4e3a\u7a7a\u3002", (String)"DepositInitSubmitValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (DepositHelper.validateHandEndPreAndRev((Date)lastPreDate, (Date)lastRevenueDate)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4e0a\u6b21\u9884\u63d0\u65e5\u4e0d\u80fd\u5c0f\u4e8e\u4e0a\u6b21\u6536\u76ca\u65e5\u3002", (String)"DepositInitSubmitValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (!DepositHelper.validateHandLastRev((Date)handRedeemDate, (Date)startDate)) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u6700\u540e\u4e00\u6b21\u89e3\u6d3b\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5b58\u6b3e\u8d77\u606f\u65e5\u3002", (String)"DepositInitSubmitValidator_9", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

