/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.init;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.helper.BusinessHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositInitUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>(8);
        QFilter qFilter = new QFilter("isinit", "=", (Object)Boolean.FALSE);
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject initBill = extData.getDataEntity();
            long initId = initBill.getLong("id");
            String currentEntity = initBill.getDynamicObjectType().getName();
            String fixedMsg = "";
            String noticeMsg = "";
            if (currentEntity.startsWith("cim_")) {
                filterMap.clear();
                filterMap.put("cim_release", qFilter);
                filterMap.put("cim_noticerelease", qFilter);
                filterMap.put("cim_dptrevenue", qFilter);
                fixedMsg = BusinessHelper.checkDirtTargetBills((String)"cim_deposit", (Long)initId, filterMap);
                noticeMsg = BusinessHelper.checkDirtTargetBills((String)"cim_noticedeposit", (Long)initId, filterMap);
            } else {
                filterMap.clear();
                filterMap.put("ifm_release", qFilter);
                filterMap.put("ifm_notice_release", qFilter);
                filterMap.put("ifm_dptrevenue", qFilter);
                fixedMsg = BusinessHelper.checkDirtTargetBills((String)"ifm_deposit", (Long)initId, filterMap);
                noticeMsg = BusinessHelper.checkDirtTargetBills((String)"ifm_notice_deposit", (Long)initId, filterMap);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(fixedMsg).append(noticeMsg);
            if (!EmptyUtil.isNoEmpty((String)sb.toString())) continue;
            this.addErrorMessage(extData, sb.toString());
        }
    }
}

