/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.init;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class FinSubscribeInitSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("handlastrevenuedate");
        selector.add("handendpredate");
        selector.add("handrevenueamt");
        selector.add("handredeemamt");
        selector.add("redeemway");
        selector.add("handredeemcopies");
        selector.add("buycopies");
        selector.add("amount");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            BigDecimal amt;
            String redeemWay;
            DynamicObject init = extData.getDataEntity();
            BigDecimal handRevAmt = init.getBigDecimal("handrevenueamt");
            Date lastRevenueDate = init.getDate("handlastrevenuedate");
            if (DepositHelper.validateHandAmtAndDate((Date)lastRevenueDate, (BigDecimal)handRevAmt)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4e0a\u6b21\u6536\u76ca\u65e5\u4e0e\u5df2\u6536\u76ca\u91d1\u989d\u8981\u4e48\u540c\u65f6\u4e3a\u7a7a\u8981\u4e48\u540c\u65f6\u4e0d\u4e3a\u7a7a\u3002", (String)"DepositInitSubmitValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (DepositHelper.validateHandEndPreAndRev((Date)init.getDate("handendpredate"), (Date)lastRevenueDate)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4e0a\u6b21\u9884\u63d0\u65e5\u4e0d\u80fd\u5c0f\u4e8e\u4e0a\u6b21\u6536\u76ca\u65e5\u3002", (String)"DepositInitSubmitValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (RedeemWayEnum.isCopiesRedeem((String)(redeemWay = init.getString("redeemway")))) {
                BigDecimal buyCopy;
                BigDecimal handRedCopy = init.getBigDecimal("handredeemcopies");
                if (handRedCopy.compareTo(buyCopy = init.getBigDecimal("buycopies")) <= 0) continue;
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5df2\u8d4e\u56de\u4efd\u6570(\u521d\u59cb\u5316)\u4e0d\u80fd\u5927\u4e8e\u8d2d\u4e70\u4efd\u6570\u3002", (String)"DepositInitSubmitValidator_10", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            BigDecimal handRedAmt = init.getBigDecimal("handredeemamt");
            if (handRedAmt.compareTo(amt = init.getBigDecimal("amount")) <= 0) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5df2\u8d4e\u56de\u91d1\u989d(\u521d\u59cb\u5316)\u4e0d\u80fd\u5927\u4e8e\u7406\u8d22\u91d1\u989d\u3002", (String)"DepositInitSubmitValidator_11", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

