/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.intbatch;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntBillBatchSaveOrSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry");
        selector.add("entry.finbillid");
        selector.add("entry.finbillno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            Set dbFinSet;
            Set finIdSet;
            DynamicObject intBatch = extData.getDataEntity();
            DynamicObjectCollection entry = intBatch.getDynamicObjectCollection("entry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entry) || EmptyUtil.isEmpty(finIdSet = entry.stream().filter(r -> EmptyUtil.isNoEmpty((Long)r.getLong("finbillid"))).map(r -> r.getLong("finbillid")).collect(Collectors.toSet()))) continue;
            QFilter qFilter = new QFilter("id", "!=", intBatch.getPkValue());
            qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
            qFilter.and("entry.finbillid", "in", finIdSet);
            DynamicObjectCollection cols = QueryServiceHelper.query((String)intBatch.getDynamicObjectType().getName(), (String)"entry.finbillid finbillid", (QFilter[])new QFilter[]{qFilter});
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)cols) || EmptyUtil.isEmpty(dbFinSet = cols.stream().filter(r -> EmptyUtil.isNoEmpty((String)"finbillid")).map(r -> r.getLong("finbillid")).collect(Collectors.toSet()))) continue;
            finIdSet.retainAll(dbFinSet);
            Map<Long, String> id2BillNoMap = entry.stream().collect(Collectors.toMap(r -> r.getLong("finbillid"), r -> r.getString("finbillno")));
            List billNos = finIdSet.stream().map(r -> (String)id2BillNoMap.get(r)).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(billNos)) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u7533\u8d2d\u5355\u3010%s\u3011\u5b58\u5728\u5728\u9014\u7684\u7406\u8d22\u6536\u76ca\u6279\u91cf\u9884\u63d0\u5355\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"IntBillBatchSaveOrSubmitValidator_1", (String)"tmc-cim-business", (Object[])new Object[]{String.join((CharSequence)",", billNos)}));
        }
    }
}

