/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.intbatch;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.OperaTypeEnum;
import kd.tmc.cim.common.enums.WriteOffStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntBillBatchUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("entry");
        sid.add("intbillid");
        sid.add("intdetailnum");
        sid.add("finbillid");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject intRevenue = dataEntity.getDataEntity();
            DynamicObjectCollection entrys = intRevenue.getDynamicObjectCollection("entry");
            List collect = entrys.stream().map(s -> s.getLong("finbillid")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("entry.finbillid", "in", collect);
            qFilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            boolean exists = TmcDataServiceHelper.exists((String)"cim_intbill_batch", (QFilter[])qFilter.toArray());
            if (exists) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u5728\u9014\u7684\u6279\u91cf\u9884\u63d0\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"IntBillBatchUnAuditValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            this.validateRevBillWriteOff(dataEntity, entrys);
        }
    }

    private void validateRevBillWriteOff(ExtendedDataEntity dataEntity, DynamicObjectCollection entrys) {
        List intBillIds = entrys.stream().map(r -> r.getLong("intbillid")).collect(Collectors.toList());
        QFilter intBillFilter = new QFilter("id", "in", intBillIds);
        intBillFilter.and(new QFilter("operatype", "=", (Object)OperaTypeEnum.INTERESTREV.getValue()));
        intBillFilter.and(new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue()));
        DynamicObjectCollection intRevenueBills = QueryServiceHelper.query((String)"cim_intbill_revenue", (String)"billno", (QFilter[])new QFilter[]{intBillFilter}, (String)"", (int)-1);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)intRevenueBills)) {
            List intRevNumbers = intRevenueBills.stream().map(r -> r.getString("billno")).collect(Collectors.toList());
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u63d0\u8bb0\u8d26\u5904\u7406\u5355\u3010%s\u3011\u5df2\u7ecf\u7ea2\u5b57\u51b2\u9500\uff0c\u7406\u8d22\u6536\u76ca\u6279\u91cf\u9884\u63d0\u5355\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"IntBillBatchUnAuditValidator_3", (String)"tmc-cim-business", (Object[])new Object[]{String.join((CharSequence)",", intRevNumbers)}));
        }
    }
}

