/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.redeem;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.RedeemBillHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RedeemBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("finbillno");
        sid.add("redeemdate");
        sid.add("redeemway");
        sid.add("amount");
        sid.add("copies");
        sid.add("iopv");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            BigDecimal amount;
            Map checkEndDate;
            String lastEndIntDate;
            DynamicObject redeem = dataEntity.getDataEntity();
            Date redeemDate = redeem.getDate("redeemdate");
            DynamicObject finBillF7 = redeem.getDynamicObject("finbillno");
            String checkRedDate = RedeemBillHelper.checkLastRedeemDate((Object)finBillF7.getPkValue(), (Date)redeemDate);
            if (EmptyUtil.isNoEmpty((String)checkRedDate)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d4e\u56de\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4e0a\u4e00\u6b21\u7684\u8d4e\u56de\u65e5\u671f[%s]\u3002", (String)"RedeemBillSaveValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]), checkRedDate));
            }
            if (EmptyUtil.isNoEmpty((String)(lastEndIntDate = (String)(checkEndDate = RedeemBillHelper.checkLastEndIntDate((Object)finBillF7.getPkValue(), (Date)redeemDate)).get("lastEndIntDate")))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d4e\u56de\u5355\u7684\u8d4e\u56de\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u7533\u8d2d\u5355\u7684\u4e0a\u6b21\u6536\u76ca\u65e5%s\u3002", (String)"RedeemBillSaveValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]), lastEndIntDate));
            }
            Map opMap = this.getOption().getVariables();
            String purchaseDate = (String)checkEndDate.get("purchaseDate");
            if (EmptyUtil.isNoEmpty((String)purchaseDate) && EmptyUtil.isEmpty((String)((String)opMap.get("pass_isinit_validate")))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d4e\u56de\u5355\u7684\u8d4e\u56de\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u7533\u8d2d\u5355\u7684\u7533\u8d2d\u65e5\u671f%s\u3002", (String)"RedeemBillSaveValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]), purchaseDate));
            }
            String redeemWay = redeem.getString("redeemway");
            String tradeChannel = redeem.getString("tradechannel");
            if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay) && EmptyUtil.isEmpty((BigDecimal)(amount = redeem.getBigDecimal("amount")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u8d4e\u56de\u91d1\u989d\"\u3002", (String)"RedeemBillSaveValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
                BigDecimal iopv;
                BigDecimal copies = redeem.getBigDecimal("copies");
                if (EmptyUtil.isEmpty((BigDecimal)copies)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u8d4e\u56de\u4efd\u6570\"\u3002", (String)"RedeemBillSaveValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((BigDecimal)(iopv = redeem.getBigDecimal("iopv"))) && !TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u5355\u4f4d\u51c0\u503c\"\u3002", (String)"RedeemBillSaveValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
            }
            QFilter idFilter = new QFilter("finbillno", "=", finBillF7.getPkValue());
            idFilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            idFilter.and("id", "!=", redeem.getPkValue());
            QFilter beBankFilter = new QFilter("finbillno", "=", finBillF7.getPkValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue()).and("bebankstatus", "not in", (Object)new String[]{BebankStatusEnum.TF.getValue(), BebankStatusEnum.TS.getValue()});
            QFilter qFilter = idFilter.or(beBankFilter);
            boolean exists = TmcDataServiceHelper.exists((String)CimEntityEnum.cim_redeem.getValue(), (QFilter[])qFilter.toArray());
            if (!exists) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8d2d\u5355\u4e0b\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u8d4e\u56de\u5355\u8bb0\u5f55\u672a\u5904\u7406\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"RedeemBillSaveValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

