/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.revenue;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.helper.IntBillBatchHelper;
import kd.tmc.cim.common.helper.RevenueCalcHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RevenueBillSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("expiredate");
        sid.add("revenuestartdate");
        sid.add("finbillno");
        sid.add("org");
        sid.add("lastpayinstdate");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        if (this.getOption().getVariables().containsKey("redwriteoffop")) {
            return;
        }
        List<Long> repeatList = this.valiRepeatSubmit(dataEntities);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Date beginDate;
            Date startinstdate;
            DynamicObject finbillNoF7;
            Long finBillId;
            DynamicObject revenue = dataEntity.getDataEntity();
            Date expireDate = revenue.getDate("expiredate");
            Date revenueStartDate = revenue.getDate("revenuestartdate");
            if (EmptyUtil.isNoEmpty((Object)expireDate) && EmptyUtil.isNoEmpty((Object)revenueStartDate) && expireDate.compareTo(revenueStartDate) <= 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5230\u8d26\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u6536\u76ca\u8ba1\u7b97\u5f00\u59cb\u65e5\u3002", (String)"RevenueBillSaveValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (repeatList.contains(finBillId = (Long)(finbillNoF7 = revenue.getDynamicObject("finbillno")).getPkValue())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u7533\u8d2d\u5355\u4e0b\u7684\u6536\u76ca\u5355\u4e0d\u5141\u8bb8\u6279\u91cf\u63d0\u4ea4\u3002", (String)"RevenueBillSubmitValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            QFilter qFilter = new QFilter("finbillno", "=", (Object)finBillId);
            QFilter submitFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue());
            DynamicObject submitRev = TmcDataServiceHelper.loadSingle((String)CimEntityEnum.cim_revenue.getValue(), (String)"billno", (QFilter[])qFilter.and(submitFilter).toArray());
            if (EmptyUtil.isNoEmpty((DynamicObject)submitRev)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8d2d\u5355\u5b58\u5728\u5df2\u63d0\u4ea4\u7684\u6536\u76ca\u5355%s\uff0c\u8bf7\u5148\u5ba1\u6838\u6216\u64a4\u9500\u3002", (String)"RevenueBillSubmitValidator_2", (String)"tmc-cim-business", (Object[])new Object[]{submitRev.getString("billno")}));
            }
            QFilter saveFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
            boolean existsSave = TmcDataServiceHelper.exists((String)CimEntityEnum.cim_revenue.getValue(), (QFilter[])qFilter.and(saveFilter).toArray());
            if (existsSave) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6536\u76ca\u5355\u5b58\u5728\u5176\u5b83\u6682\u5b58\u72b6\u6001\u7684\u6536\u76ca\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\u5f53\u524d\u6536\u76ca\u5355\uff1f", (String)"RevenueBillSubmitValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]), ErrorLevel.Warning);
            }
            if (!EmptyUtil.isNoEmpty((Object)(startinstdate = revenue.getDate("revenuestartdate")))) continue;
            Date endlastinstdate = finbillNoF7.getDate("endinstdate");
            String message = ResManager.loadKDString((String)"\u6536\u76ca\u5355\u6536\u76ca\u8ba1\u7b97\u5f00\u59cb\u65e5\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u8bf7\u5728\u5355\u636e\u9875\u9762\u786e\u8ba4\u540e\u63d0\u4ea4\u3002", (String)"RevenueBillSubmitValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]);
            if (this.getOption().getVariables().containsKey("intbatch") && !IntBillBatchHelper.isAutoWriteRed((DynamicObject)finbillNoF7)) {
                endlastinstdate = finbillNoF7.getDate("lastpayinstdate");
                message = ResManager.loadKDString((String)"\u7406\u8d22\u7533\u8d2d\u5355\u53f7%s\u7684\u6536\u76ca\u8ba1\u7b97\u5f00\u59cb\u65e5\u5df2\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u7406\u8d22\u6536\u76ca\u6279\u91cf\u9884\u63d0\u3002", (String)"RevenueBillSubmitValidator_5", (String)"tmc-cim-business", (Object[])new Object[]{finbillNoF7.getString("number")});
            }
            if (startinstdate.compareTo(beginDate = EmptyUtil.isEmpty((Object)endlastinstdate) ? RevenueCalcHelper.getStartIntDate((DynamicObject)finbillNoF7) : DateUtils.getNextDay((Date)endlastinstdate, (int)1)) == 0) continue;
            this.addErrorMessage(dataEntity, message);
        }
    }

    private List<Long> valiRepeatSubmit(ExtendedDataEntity[] dataEntities) {
        ArrayList<Long> repeatList = new ArrayList<Long>();
        if (EmptyUtil.isEmpty((Object[])dataEntities)) {
            return repeatList;
        }
        ArrayList<Long> exisList = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject revenue = dataEntity.getDataEntity();
            DynamicObject finbillNoF7 = revenue.getDynamicObject("finbillno");
            Long finBillId = (Long)finbillNoF7.getPkValue();
            if (exisList.contains(finBillId)) {
                repeatList.add(finBillId);
            }
            exisList.add(finBillId);
        }
        return repeatList;
    }
}

