/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.revenue;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.helper.RedeemBillHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RevenueBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("revenuesort");
        sid.add("finbillno");
        sid.add("id");
        sid.add("billno");
        sid.add("isinit");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject targetBill;
            DynamicObject revenue = dataEntity.getDataEntity();
            String revenueSort = revenue.getString("revenuesort");
            if (RevenueSortEnum.redeem_revenue.getValue().equals(revenueSort)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d4e\u56de\u6536\u76ca\u7c7b\u578b\u7684\u6536\u76ca\u5355\u636e\u6b64\u5904\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"RevenueBillUnAuditValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            String entityName = revenue.getDataEntityType().getName();
            DynamicObject finbillNoF7 = revenue.getDynamicObject("finbillno");
            String dataSource = "cim_intbill_revenue".equals(entityName) ? "interestrev" : "revenue";
            String checkRev = RedeemBillHelper.checkIsLastRevenue((Object)finbillNoF7.getPkValue(), (DynamicObject)revenue, (String)dataSource);
            if (EmptyUtil.isNoEmpty((String)checkRev)) {
                this.addErrorMessage(dataEntity, checkRev);
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(targetBill = TmcBotpHelper.getTargetBill((String)CimEntityEnum.cim_revenue.getValue(), (Object)revenue.getPkValue(), (String)CimEntityEnum.cas_recbill.getValue())))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u88ab\u6536\u6b3e\u5355\u5173\u8054\uff0c\u8bf7\u5148\u5220\u9664\u4e0b\u6e38\u5355\u636e\u518d\u505a\u53cd\u5ba1\u6838\u3002", (String)"RedeemBillUnAuditValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            Map opMap = this.getOption().getVariables();
            if (!revenue.getBoolean("isinit") || !EmptyUtil.isEmpty((String)((String)opMap.get("pass_isinit_validate")))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u6536\u76ca\u5355\uff0c\u53ea\u80fd\u5728\u7533\u8d2d\u521d\u59cb\u5316\u5355\u64cd\u4f5c\u53cd\u5ba1\u6838\u3002", (String)"RedeemBillUnAuditValidator_8", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

