/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.scheme;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.InterestTypeEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositSchemeSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        this.validateDepositApply(dataEntity);
        ArrayList<Object> schemeIds = new ArrayList<Object>(dataEntity.length);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            String interestType;
            DynamicObject depositScheme = extendedDataEntity.getDataEntity();
            StringJoiner nullFields = new StringJoiner("\u3001");
            if (EmptyUtil.isEmpty((BigDecimal)depositScheme.getBigDecimal("amount"))) {
                nullFields.add(ResManager.loadKDString((String)"\u201c\u5b58\u6b3e\u91d1\u989d\u201d", (String)"DepositApplySchemeSaveValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (StringUtils.equals((CharSequence)(interestType = depositScheme.getString("interesttype")), (CharSequence)InterestTypeEnum.FLOAT.getValue()) && EmptyUtil.isEmpty((DynamicObject)depositScheme.getDynamicObject("referencerate"))) {
                nullFields.add(ResManager.loadKDString((String)"\u201c\u53c2\u8003\u5229\u7387\u201d", (String)"DepositApplySchemeSaveValidator_12", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (nullFields.length() > 0) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"FinApplySubmitValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]), nullFields.toString()));
            }
            schemeIds.add(depositScheme.getPkValue());
            this.validateRangeRate(extendedDataEntity, depositScheme);
        }
        this.validateDepositStatus(dataEntity, schemeIds);
    }

    private void validateDepositStatus(ExtendedDataEntity[] dataEntity, List<Object> schemeIds) {
        DynamicObjectCollection depositSchemeFromDB = QueryServiceHelper.query((String)EntityMetadataCache.getDataEntityType((String)"cim_depositscheme").getName(), (String)String.join((CharSequence)",", "id", "status"), (QFilter[])new QFilter[]{new QFilter("id", "in", schemeIds)});
        Map<Object, DynamicObject> depositSchemeMap = depositSchemeFromDB.stream().collect(Collectors.toMap(d -> d.get("id"), o -> o));
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject depositSchemeDb = depositSchemeMap.get(extendedDataEntity.getDataEntity().getPkValue());
            if (depositSchemeDb == null || BillStatusEnum.SAVE.getValue().equals(depositSchemeDb.getString("status"))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u975e\u6682\u5b58\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DepositSchemeSaveValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private void validateDepositApply(ExtendedDataEntity[] dataEntity) {
        String operateParam = this.getOption().getVariables().getOrDefault("fromdepositapply", null);
        if (EmptyUtil.isNoEmpty((String)operateParam)) {
            return;
        }
        Object[] schemeIds = Arrays.stream(dataEntity).map(v -> v.getDataEntity().getPkValue()).toArray();
        DynamicObject[] depositSchemeSFromDB = TmcDataServiceHelper.load((Object[])schemeIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_depositscheme"));
        Map<Object, DynamicObject> depositSchemeMap = Arrays.stream(depositSchemeSFromDB).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject depositSchemeFromDB;
            DynamicObject depositScheme = extendedDataEntity.getDataEntity();
            DynamicObject depositApply = depositScheme.getDynamicObject("depositapply");
            if (EmptyUtil.isEmpty((DynamicObject)depositApply) || EmptyUtil.isNoEmpty((DynamicObject)(depositSchemeFromDB = depositSchemeMap.get(depositScheme.getPkValue()))) && EmptyUtil.isNoEmpty((DynamicObject)depositSchemeFromDB.getDynamicObject("depositapply")) && StringUtils.equals((CharSequence)depositSchemeFromDB.getDynamicObject("depositapply").getString("number"), (CharSequence)depositApply.getString("number"))) continue;
            if (StringUtils.equals((CharSequence)depositApply.getString("billstatus"), (CharSequence)BillStatusEnum.AUDIT.getValue()) || StringUtils.equals((CharSequence)depositApply.getString("billstatus"), (CharSequence)BillStatusEnum.SUBMIT.getValue())) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5b58\u6b3e\u65b9\u6848\u53ea\u80fd\u5173\u8054\u6682\u5b58\u7684\u5b58\u6b3e\u7533\u8bf7\u5355\u3002", (String)"DepositSchemeSaveValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (depositApply.getBoolean("inquiry")) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5b58\u6b3e\u65b9\u6848\u53ea\u80fd\u5173\u8054\u5f00\u542f\u5b58\u6b3e\u8be2\u4ef7\u7684\u5b58\u6b3e\u7533\u8bf7\u5355\u3002", (String)"DepositSchemeSaveValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private void validateRangeRate(ExtendedDataEntity extendData, DynamicObject depositApply) {
        List msgList = DepositHelper.validateRangeRate((DynamicObject)depositApply, (boolean)false);
        if (EmptyUtil.isNoEmpty((Object)msgList)) {
            for (String msg : msgList) {
                this.addErrorMessage(extendData, msg);
            }
        }
    }
}

