/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.supermarket;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class MarketCmbSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("cmb_subamtceil");
        selector.add("cmb_subamtfloor");
        selector.add("cmb_redeemceil");
        selector.add("cmb_redeemfloor");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject cmbBill = extData.getDataEntity();
            this.validateSubAmtRelation(extData, cmbBill);
            this.validateRedeemAmtRelation(extData, cmbBill);
        }
    }

    private void validateSubAmtRelation(ExtendedDataEntity extData, DynamicObject cmbBill) {
        BigDecimal subAmtFloor;
        BigDecimal subAmtCeil = cmbBill.getBigDecimal("cmb_subamtceil");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{subAmtCeil, subAmtFloor = cmbBill.getBigDecimal("cmb_subamtfloor")}) && subAmtCeil.compareTo(subAmtFloor) < 0) {
            String errMsg = ResManager.loadKDString((String)"\u7533\u8d2d\u91d1\u989d\u4e0a\u9650\u4e0d\u80fd\u5c0f\u4e8e\u7533\u8d2d\u91d1\u989d\u4e0b\u9650\u3002", (String)"MarketCmbSaveValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]);
            this.addErrorMessage(extData, errMsg);
            this.getValidateResult().setMessage(errMsg);
        }
    }

    private void validateRedeemAmtRelation(ExtendedDataEntity extData, DynamicObject cmbBill) {
        BigDecimal redeemAmtFloor;
        BigDecimal redeemAmtCeil = cmbBill.getBigDecimal("cmb_redeemceil");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{redeemAmtCeil, redeemAmtFloor = cmbBill.getBigDecimal("cmb_redeemfloor")}) && redeemAmtCeil.compareTo(redeemAmtFloor) < 0) {
            String errMsg = ResManager.loadKDString((String)"\u8d4e\u56de\u4e0a\u9650\u4e0d\u80fd\u5c0f\u4e8e\u8d4e\u56de\u4e0b\u9650\u3002", (String)"MarketCmbSaveValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]);
            this.addErrorMessage(extData, errMsg);
            this.getValidateResult().setMessage(errMsg);
        }
    }
}

