/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.DepositTermEnum;
import kd.tmc.cim.common.enums.RateSignEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositApplySchemeBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit depositScheme = (BasedataEdit)this.getControl("c_depositscheme");
        depositScheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("c_org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit investVarieties = (BasedataEdit)this.getControl("c_investvarieties");
        investVarieties.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "c_expiredate": {
                this.expireDateChgEvt();
                break;
            }
            case "c_term": {
                this.termChgEvt((String)args.getChangeSet()[0].getOldValue());
                break;
            }
            case "c_intdate": {
                this.intDateChgEvt((Date)args.getChangeSet()[0].getOldValue());
                break;
            }
            case "c_amount": 
            case "c_interestrate": {
                this.syncCardInfo(propName);
                break;
            }
            case "c_finorginfo": {
                this.syncCardInfo(propName);
                this.updateCardEntryView(propName);
                break;
            }
            case "c_investvarieties": {
                this.syncCardInfo(propName);
                this.updateCardEntryView(propName);
                this.investVarietiesChgEvt();
                this.setViewRule();
                break;
            }
            case "c_org": {
                this.updateCardEntryView(propName);
                break;
            }
            case "c_currency": {
                this.updateCardEntryView(propName);
                int rowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
                this.getModel().setValue("s_currency", args.getChangeSet()[0].getNewValue(), rowIndex);
                break;
            }
            case "c_tradechannel": {
                this.tradeChannelChgEvt(false);
                break;
            }
            case "c_deadline": {
                this.calExpireDate((String)this.getCardEntryValue("c_tradechannel"));
                break;
            }
            case "c_interesttype": {
                this.interestTypeChgEvt();
                break;
            }
            case "c_depositscheme": {
                this.depositSchemeNoChgEvt();
                break;
            }
            case "c_rangemin": 
            case "c_rangemax": {
                this.setDefaultRate();
                break;
            }
        }
    }

    private void investVarietiesChgEvt() {
        String number;
        DynamicObject product;
        boolean flag;
        DynamicObject investVarieties = (DynamicObject)this.getCardEntryValue("c_investvarieties");
        boolean bl = flag = EmptyUtil.isNoEmpty((DynamicObject)investVarieties) && investVarieties.getBoolean("isproduct");
        if (flag && EmptyUtil.isNoEmpty((DynamicObject)(product = TmcDataServiceHelper.loadSingleFromCache((String)"ifm_ldproduct", (String)"center,currency,ratetype,productprice,referrate,ratesignbp,ratefloatpoints", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(number = investVarieties.getString("number")))})))) {
            this.setCardEntryValue("c_finorginfo", product.getDynamicObject("center"));
            this.setCardEntryValue("c_currency", product.getDynamicObject("currency"));
            Integer parentRowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
            this.getModel().setValue("c_interesttype", (Object)product.getString("ratetype"), 0, parentRowIndex.intValue());
            this.setCardEntryValue("c_interestrate", product.getBigDecimal("productprice"));
            this.setCardEntryValue("c_referencerate", product.getDynamicObject("referrate"));
            this.setCardEntryValue("c_ratesign", product.getString("ratesignbp"));
            this.setCardEntryValue("c_ratefloatpoint", product.getBigDecimal("ratefloatpoints"));
            this.getModel().setValue("c_tradechannel", (Object)TradeChannelEnum.OFFLINE.getValue(), 0, parentRowIndex.intValue());
            this.syncCardInfo("c_interestrate");
        }
    }

    private void depositSchemeNoChgEvt() {
        Integer rowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
        DynamicObject depositScheme = (DynamicObject)this.getModel().getValue("c_depositscheme", 0, rowIndex.intValue());
        if (EmptyUtil.isEmpty((DynamicObject)depositScheme)) {
            this.setCardEntryValue("c_schemeid", DB.genLongId((String)"cim_depositscheme"));
            this.getView().updateView("c_depositscheme", 0, rowIndex.intValue());
            return;
        }
        DynamicObject schemeEntry = this.getModel().getEntryRowEntity("s_entry", rowIndex.intValue());
        DynamicObject currentScheme = (DynamicObject)schemeEntry.getDynamicObjectCollection("c_entry").get(0);
        DataEntityPropertyCollection properties = currentScheme.getDynamicObjectType().getProperties();
        for (IDataEntityProperty prop : properties) {
            String propName = prop.getName();
            if (!propName.startsWith("c_")) continue;
            if (StringUtils.equals((CharSequence)"c_schemeid", (CharSequence)propName)) {
                currentScheme.set(propName, (Object)depositScheme.getLong("id"));
                continue;
            }
            if (propName.startsWith("c_depositscheme")) continue;
            currentScheme.set(propName, depositScheme.get(propName.replace("c_", "")));
        }
        DynamicObject currencyDo = currentScheme.getDynamicObject("c_currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)currencyDo)) {
            currencyDo = TmcDataServiceHelper.loadSingle((Object)currencyDo.getPkValue(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_currency"));
            currentScheme.set("c_currency", (Object)currencyDo);
        }
        this.getModel().setDataChanged(false);
        this.syncCardInfo("c_finorginfo");
        this.syncCardInfo("c_investvarieties");
        this.syncCardInfo("c_amount");
        this.syncCardInfo("c_interestrate");
        for (IDataEntityProperty prop : properties) {
            String propName = prop.getName();
            if (!propName.startsWith("c_") || "c_schemeid".equals(propName) || propName.startsWith("c_depositscheme")) continue;
            this.getView().updateView(propName, 0, rowIndex.intValue());
        }
        ((CardEntry)this.getControl("s_entry")).selectCard(rowIndex);
    }

    private void interestTypeChgEvt() {
        String interestType = (String)this.getCardEntryValue("c_interesttype");
        if (InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            this.setCardEntryValue("c_interestrate", null);
            this.setCardEntryValue("c_ratesign", RateSignEnum.ADD.getValue());
        } else if (InterestTypeEnum.FIXED.getValue().equals(interestType)) {
            this.setCardEntryValue("c_ratesign", null);
            this.setCardEntryValue("c_referencerate", null);
            this.setCardEntryValue("c_ratefloatpoint", null);
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)InterestTypeEnum.FLOAT.getValue().equals(interestType), (String[])new String[]{"c_referencerate"});
    }

    private void setViewRule() {
        DynamicObject investVarieties = (DynamicObject)this.getCardEntryValue("c_investvarieties");
        if (EmptyUtil.isEmpty((DynamicObject)investVarieties)) {
            return;
        }
        String investType = investVarieties.getString("investtype");
        boolean isShow = InvestTypeEnum.isFixed((String)investType);
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"c_expireredeposit"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isShow, (String[])new String[]{"c_expireredeposit"});
        isShow = InvestTypeEnum.isNotice((String)investType);
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"c_prenoticeday"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isShow, (String[])new String[]{"c_prenoticeday"});
    }

    private void tradeChannelChgEvt(boolean isInit) {
        boolean isAddNew;
        String tradeChannel = (String)this.getCardEntryValue("c_tradechannel");
        boolean isOnline = StringUtils.equals((CharSequence)tradeChannel, (CharSequence)TradeChannelEnum.ONLINE.getValue());
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus opStatus = billShowParameter.getStatus();
        boolean bl = isAddNew = opStatus == OperationStatus.ADDNEW;
        if ((isAddNew || !isInit) && isOnline) {
            this.setCardEntryValue("c_term", null);
            this.setCardEntryValue("c_deadline", DepositTermEnum.SIXMONTH.getValue());
            Integer parentRowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
            this.getModel().setValue("c_interesttype", (Object)InterestTypeEnum.FIXED.getValue(), 0, parentRowIndex.intValue());
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"c_intdate", "c_expiredate"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isOnline, (String[])new String[]{"c_deadline"});
    }

    private void calExpireDate(String tradeChannel) {
        Date expireDate;
        Date intDate = (Date)this.getCardEntryValue("c_intdate");
        if (StringUtils.equals((CharSequence)TradeChannelEnum.OFFLINE.getValue(), (CharSequence)tradeChannel)) {
            String term = (String)this.getCardEntryValue("c_term");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, term})) {
                return;
            }
            expireDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)intDate);
        } else {
            String deadLine = (String)this.getCardEntryValue("c_deadline");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, deadLine})) {
                return;
            }
            expireDate = DepositHelper.calEndDate((Date)intDate, (String)deadLine);
        }
        this.setCardEntryValue("c_expiredate", expireDate);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int currRowIndex = e.getRowDataEntities()[0].getRowIndex();
        if (currRowIndex < 0) {
            return;
        }
        CardEntry cardEntry = (CardEntry)this.getControl("s_entry");
        cardEntry.selectCard(Integer.valueOf(currRowIndex));
        if (!CollectionUtils.isEmpty((Collection)this.getModel().getDataEntity(true).getDynamicObjectCollection("s_entry"))) {
            this.setCardEntryValue("c_schemeid", DB.genLongId((String)"cim_depositscheme"));
            DynamicObject applyOrg = (DynamicObject)this.getModel().getValue("applyorg");
            DynamicObject org = (DynamicObject)this.getCardEntryValue("c_org");
            if (EmptyUtil.isNoEmpty((DynamicObject)applyOrg) && EmptyUtil.isEmpty((DynamicObject)org)) {
                this.setCardEntryValue("c_org", applyOrg);
                this.setCardEntryValue("c_currency", SystemStatusCtrolHelper.getStandardCurrency((long)applyOrg.getLong("id")));
            }
            this.setViewRule();
        }
    }

    public void syncCardInfo(String propName) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
        DynamicObject cardEntry = this.getModel().getEntryRowEntity("s_entry", rowIndex);
        if (EmptyUtil.isEmpty((DynamicObject)cardEntry) || CollectionUtils.isEmpty((Collection)cardEntry.getDynamicObjectCollection("c_entry"))) {
            return;
        }
        Object value = ((DynamicObject)cardEntry.getDynamicObjectCollection("c_entry").get(0)).get(propName);
        this.getModel().setValue(propName.replace("c_", "s_"), value, rowIndex);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propName;
        switch (propName = event.getProperty().getName()) {
            case "c_depositscheme": {
                this.setDepositSchemeOrgFilter(event);
                this.setDepositSchemeFilter(event);
                break;
            }
            case "c_org": {
                this.setOrgFilter(event);
                break;
            }
            case "c_investvarieties": {
                this.setInvestVarietiesFilter(event);
                break;
            }
        }
    }

    private void setDepositSchemeFilter(BeforeF7SelectEvent event) {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("s_entry");
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        ArrayList<String> numberList = new ArrayList<String>();
        for (DynamicObject cardEntry : collection) {
            Object value = ((DynamicObject)cardEntry.getDynamicObjectCollection("c_entry").get(0)).get("c_depositscheme");
            if (value == null) continue;
            numberList.add(((DynamicObject)value).getString("number"));
        }
        if (CollectionUtils.isEmpty(numberList)) {
            return;
        }
        QFilter qFilter = new QFilter("number", "not in", numberList);
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private void setDepositSchemeOrgFilter(BeforeF7SelectEvent event) {
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdCollection = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("org.id", "in", (Object)orgIdCollection);
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private void setOrgFilter(BeforeF7SelectEvent e) {
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdCollection = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("id", "in", (Object)orgIdCollection.toArray());
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.setMultiSelect(false);
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private void setInvestVarietiesFilter(BeforeF7SelectEvent e) {
        DynamicObject finOrg = (DynamicObject)this.getCardEntryValue("c_finorginfo");
        if (EmptyUtil.isEmpty((DynamicObject)finOrg)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b58\u6b3e\u673a\u6784\u201d\u3002", (String)"DepositApplyEdit_6", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        boolean settleCenterBill = this.isSettleCenterBill();
        if (settleCenterBill) {
            List numberList;
            List investIds;
            ListShowParameter f7ShowParam = (ListShowParameter)e.getFormShowParameter();
            f7ShowParam.setCaption(ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u5b58\u6b3e\u4ea7\u54c1", (String)"DepositApplyEdit_7", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            Map productMap = TmcDataServiceHelper.loadFromCache((String)"ifm_ldproduct", (String)"number", (QFilter[])new QFilter[]{new QFilter("center", "=", finOrg.getPkValue())});
            if (EmptyUtil.isEmpty((Object)productMap) || productMap.size() == 0) {
                f7ShowParam.getListFilterParameter().getQFilters().add(new QFilter("id", "=", (Object)0L));
            }
            if (EmptyUtil.isNoEmpty((Object)(investIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_investvarieties", (QFilter[])new QFilter[]{new QFilter("number", "in", numberList = productMap.values().stream().map(r -> r.getString("number")).collect(Collectors.toList()))}, null, (int)-1)))) {
                f7ShowParam.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)investIds));
            }
        }
    }

    private boolean isSettleCenterBill() {
        Integer rowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
        DynamicObject depositBill = this.getModel().getEntryRowEntity("c_entry", 0, rowIndex.intValue());
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return false;
        }
        DynamicObject finOrgInfo = depositBill.getDynamicObject("c_finorginfo");
        if (EmptyUtil.isEmpty((DynamicObject)finOrgInfo)) {
            return false;
        }
        finOrgInfo = TmcDataServiceHelper.loadSingleFromCache((Object)finOrgInfo.getPkValue(), (String)"bd_finorginfo");
        return StringUtils.equals((CharSequence)finOrgInfo.getDynamicObject("finorgtype").getString("type"), (CharSequence)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
    }

    private void calcTerm() {
        Date startDate = (Date)this.getCardEntryValue("c_intdate");
        Date expireDate = (Date)this.getCardEntryValue("c_expiredate");
        if (null == startDate || null == expireDate) {
            return;
        }
        String term = DateUtils.getDiff_ymd((Date)startDate, (Date)expireDate);
        this.setCardEntryValue("c_term", term);
    }

    private boolean checkExpireDate() {
        Date expireDate = (Date)this.getCardEntryValue("c_expiredate");
        Date intDate = (Date)this.getCardEntryValue("c_intdate");
        if (EmptyUtil.isNoEmpty((Object)expireDate) && EmptyUtil.isNoEmpty((Object)intDate) && intDate.after(expireDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u6b3e\u5230\u671f\u65e5\u5fc5\u987b\u5927\u4e8e\u5b58\u6b3e\u8d77\u606f\u65e5\u3002", (String)"DepositApplySchemeBillEdit_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            this.setCardEntryValue("c_expiredate", null);
            return false;
        }
        return true;
    }

    private boolean checkTermIsRight(String oldValue) {
        String term = (String)this.getCardEntryValue("c_term");
        boolean rightFormat = TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)term);
        if (!rightFormat) {
            this.setCardEntryValue("c_term", oldValue);
        }
        return rightFormat;
    }

    private void calExpireDate() {
        Date startDate = (Date)this.getCardEntryValue("c_intdate");
        String termStr = (String)this.getCardEntryValue("c_term");
        if (null == startDate || EmptyUtil.isEmpty((String)termStr)) {
            this.setCardEntryValue("c_expiredate", null);
            return;
        }
        this.setCardEntryValue("c_expiredate", TermHelper.getDateByTerm((String)termStr, (Date)startDate));
    }

    private void expireDateChgEvt() {
        if (this.checkExpireDate()) {
            this.calcTerm();
        }
    }

    private void termChgEvt(String oldValue) {
        if (this.checkTermIsRight(oldValue)) {
            this.calExpireDate();
        }
    }

    private void updateCardEntryView(String propName) {
        this.getView().updateView(propName, 0);
    }

    private Object getCardEntryValue(String propName) {
        Integer parentRowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
        return this.getModel().getValue(propName, 0, parentRowIndex.intValue());
    }

    private void setCardEntryValue(String propName, Object value) {
        Integer parentRowIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)value, (int)0, (int)parentRowIndex);
    }

    private void intDateChgEvt(Date oldValue) {
        Date intDate = (Date)this.getCardEntryValue("c_intdate");
        if (EmptyUtil.isEmpty((Object)intDate)) {
            return;
        }
        Date expireDate = (Date)this.getCardEntryValue("c_expiredate");
        if (EmptyUtil.isNoEmpty((Object)expireDate) && intDate.after(expireDate)) {
            intDate = oldValue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u4e0d\u80fd\u5927\u4e8e\u5b58\u6b3e\u5230\u671f\u65e5\u3002", (String)"DepositApplySchemeBillEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            this.setCardEntryValue("c_intdate", intDate);
        }
    }

    private void setDefaultRate() {
        BigDecimal rangeMin = (BigDecimal)this.getModel().getValue("c_rangemin");
        BigDecimal rangeMax = (BigDecimal)this.getModel().getValue("c_rangemax");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{rangeMin, rangeMax})) {
            return;
        }
        BigDecimal halfValue = rangeMin.add(rangeMax).divide(new BigDecimal("2"));
        this.getModel().setValue("c_interestrate", (Object)halfValue);
    }
}

