/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.apply;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.FinApplyTypeEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.helper.FinSubscribeHelper;
import kd.tmc.cim.common.helper.RedeemBillHelper;
import kd.tmc.cim.common.helper.SuperMarketHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinApplyEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit finSubscribe = (BasedataEdit)this.getControl("finsubscribe");
        finSubscribe.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cproduct = (BasedataEdit)this.getControl("c_product");
        cproduct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldName = evt.getProperty().getName();
        if ("finsubscribe".equals(fieldName)) {
            this.setFinSubscribeFilter(evt);
        } else if ("c_product".equals(fieldName)) {
            DynamicObject finOrg = (DynamicObject)this.getModel().getValue("c_finorginfo");
            FinSubscribeHelper.setProductFilter((BeforeF7SelectEvent)evt, (DynamicObject)finOrg);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCurrency();
        this.setProduct();
        FinSubscribeHelper.productChgEvt((IDataModel)this.getModel());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showSchemeSelectView();
        this.setMustInputProps();
        boolean inQuiry = (Boolean)this.getModel().getValue("inquiry");
        if (!inQuiry) {
            SuperMarketHelper.addAmountTips((IFormView)this.getView(), (IDataModel)this.getModel());
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().deleteEntryData("entry");
        FinSubscribeHelper.productChgEvt((IDataModel)this.getModel());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                operate.getOption().setVariableValue("param_save_bycard", "true");
                break;
            }
            case "submit": {
                operate.getOption().setVariableValue("param_save_bycard", "true");
                boolean inquiry = (Boolean)this.getModel().getValue("inquiry");
                if (!inquiry || !CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("s_entry"))) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7406\u8d22\u65b9\u6848\u4fe1\u606f\u3002", (String)"FinApplyEdit_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        OperationResult operationResult = args.getOperationResult();
        if (EmptyUtil.isEmpty((Object)operationResult) || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey = args.getOperateKey()) {
            case "submit": 
            case "unsubmit": 
            case "unaudit": {
                this.getView().updateView();
                this.getModel().setDataChanged(false);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldName;
        super.propertyChanged(args);
        switch (fieldName = args.getProperty().getName()) {
            case "inquiry": {
                this.setCurrencyEnable();
                this.inQuiryChgEvt();
                break;
            }
            case "finsubscribe": {
                this.finSubscribeChgEvt();
                break;
            }
            case "redemptioncopies": {
                this.calAmount();
                break;
            }
            case "redemptioniopv": {
                this.calAmount();
                break;
            }
            case "applytype": {
                this.applyTypeChgEvt();
                this.callPlanAmount();
                break;
            }
            case "isrenewal": {
                this.checkCanIsRenewal();
                break;
            }
            case "product": {
                FinSubscribeHelper.productChgEvt((IDataModel)this.getModel());
                SuperMarketHelper.addAmountTips((IFormView)this.getView(), (IDataModel)this.getModel());
                break;
            }
            case "c_product": {
                this.cardProductChgEvt();
                break;
            }
            case "redemptionamount": 
            case "redemptiondate": {
                this.callPlanAmount();
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String field;
        switch (field = e.getKey()) {
            case "redemptiondate": {
                this.checkRedemptionDate(e);
                break;
            }
            case "redemptioncopies": {
                this.checkCopies(e);
                break;
            }
        }
    }

    private void cardProductChgEvt() {
        int parentIndex = this.getModel().getEntryCurrentRowIndex("s_entry");
        DynamicObject product = (DynamicObject)this.getModel().getValue("c_product", 0, parentIndex);
        if (EmptyUtil.isEmpty((DynamicObject)product)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"currency"});
            return;
        }
        this.getModel().setValue("c_productno", (Object)product.getString("number"), 0, parentIndex);
        this.getModel().setValue("c_name", (Object)product.getString("name"), 0, parentIndex);
        this.getModel().setValue("currency", (Object)product.getDynamicObject("currency"));
        this.getView().setEnable(Boolean.FALSE, new String[]{"currency"});
        this.getModel().setValue("c_revenuetype", (Object)product.getString("revenuetype"), 0, parentIndex);
        String planRevenueStr = product.getString("planrevenue");
        this.getModel().setValue("c_planrevenue", (Object)FinSubscribeHelper.dealPlanRevenue((String)planRevenueStr), 0, parentIndex);
        this.getModel().setValue("c_floatplanrevenue", (Object)product.getBigDecimal("floatplanrevenue"), 0, parentIndex);
        String buyway = product.getString("buyway");
        if (StringUtils.equals((CharSequence)RedeemWayEnum.amount_redeem.getValue(), (CharSequence)buyway) || StringUtils.equals((CharSequence)RedeemWayEnum.copies_redeem.getValue(), (CharSequence)buyway)) {
            this.getModel().setValue("c_redeemway", (Object)buyway, 0, parentIndex);
        }
    }

    private void initCurrency() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return;
        }
        DynamicObject currency = TmcBusinessBaseHelper.getBaseCurrency((long)org.getLong("id"));
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            this.getModel().setValue("currency", currency.getPkValue());
        }
    }

    private void showSchemeSelectView() {
        String billstatus = (String)this.getModel().getValue("billstatus");
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.SAVE.getValue())) {
            this.inQuiryChgEvt();
        } else if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.SUBMIT.getValue())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            this.getView().setEnable(Boolean.valueOf(EmptyUtil.isNoEmpty(customParams.get("SCENE")) || EmptyUtil.isNoEmpty(customParams.get("fromselect"))), new String[]{"entry"});
            this.getView().setVisible(Boolean.valueOf(EmptyUtil.isNoEmpty(customParams.get("fromselect"))), new String[]{"bar_savescheme"});
        }
    }

    private void inQuiryChgEvt() {
        boolean inQuiry = (Boolean)this.getModel().getValue("inquiry");
        if (inQuiry) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"finaccountf7"});
            this.loadSchemeCardInfo();
        } else {
            this.getModel().deleteEntryData("s_entry");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"redeempatternstr", (Object)"T +");
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!inQuiry ? 1 : 0) != 0, (String[])new String[]{"productno", "investvarieties", "finorginfo", "valuedate", "risklevel", "redeempatternstr", "redeemway", "basis", "redeempattern", "bonusway", "redeempattern", "finaccount", "productname", "amount", "revenuetype"});
    }

    private void checkCanIsRenewal() {
        boolean isRenewal = (Boolean)this.getModel().getValue("isrenewal");
        if (isRenewal) {
            if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"finsubscribe")) {
                this.getModel().setValue("isrenewal", (Object)false);
                return;
            }
            DynamicObject finSubscribe = (DynamicObject)this.getModel().getValue("finsubscribe");
            Date expireDate = finSubscribe.getDate("expiredate");
            if (EmptyUtil.isEmpty((Object)expireDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u8d2d\u5355\u7684\u5230\u671f\u65e5\u4e3a\u7a7a\u65f6\uff0c\u4e0d\u5141\u8bb8\u6253\u5f00\u201c\u7406\u8d22\u7eed\u671f\u201d\u3002", (String)"RedeemBillEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("isrenewal", (Object)false);
                return;
            }
            String redeemWay = (String)this.getModel().getValue("redeemway");
            if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
                BigDecimal redemptionAmount;
                BigDecimal surplusAmount = finSubscribe.getBigDecimal("surplusamount");
                if (BigDecimal.ZERO.compareTo(surplusAmount.subtract(redemptionAmount = (BigDecimal)this.getModel().getValue("redemptionamount"))) < 0) {
                    this.getModel().setValue("isrenewal", (Object)Boolean.FALSE);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u6700\u540e\u4e00\u6b21\u8d4e\u56de\u65f6\u5f00\u542f\u7406\u8d22\u7eed\u671f\u3002", (String)"RedeemBillEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                BigDecimal copies;
                BigDecimal surplusCopies = finSubscribe.getBigDecimal("surpluscopies");
                if (surplusCopies.compareTo(copies = (BigDecimal)this.getModel().getValue("redemptioncopies")) > 0) {
                    this.getModel().setValue("isrenewal", (Object)Boolean.FALSE);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u6700\u540e\u4e00\u6b21\u8d4e\u56de\u65f6\u5f00\u542f\u7406\u8d22\u7eed\u671f\u3002", (String)"RedeemBillEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }

    private void applyTypeChgEvt() {
        String applyType = (String)this.getModel().getValue("applytype");
        HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(1);
        if (FinApplyTypeEnum.REDEEM.getValue().equals(applyType)) {
            this.getModel().setValue("inquiry", (Object)false);
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"finsubscribe", "redemptionamount", "redemptiondate"});
            props.put("text", new LocaleString(ResManager.loadKDString((String)"\u7406\u8d22\u7533\u8d2d\u4fe1\u606f", (String)"FinApplyEdit_2", (String)"tmc-cim-formplugin", (Object[])new Object[0])));
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"finsubscribe", "redemptionamount", "redemptiondate", "redemptioncopies", "redemptioniopv"});
            this.getModel().setValue("finsubscribe", null);
            this.getModel().setValue("remark", null);
            props.put("text", new LocaleString(ResManager.loadKDString((String)"\u7406\u8d22\u65b9\u6848\u4fe1\u606f", (String)"FinApplyEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0])));
        }
        this.getView().updateControlMetadata("productinfo", props);
    }

    private void finSubscribeChgEvt() {
        this.getModel().setValue("inquiry", (Object)false);
        DynamicObject finSubscribe = (DynamicObject)this.getModel().getValue("finsubscribe");
        if (EmptyUtil.isNoEmpty((DynamicObject)finSubscribe)) {
            this.getModel().setValue("currency", finSubscribe.get("currency"));
            this.getModel().setValue("redeemway", finSubscribe.get("redeemway"));
            String redeemWay = finSubscribe.getString("redeemway");
            if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
                this.getModel().setValue("redemptionamount", finSubscribe.get("surplusamount"));
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"redemptioncopies", "redemptioniopv"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"redemptionamount", "redemptiondate"});
            } else if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
                this.getModel().setValue("redemptioncopies", finSubscribe.get("surpluscopies"));
                this.getModel().setValue("redemptioniopv", finSubscribe.get("iopv"));
                this.calAmount();
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"revenuetype"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"redemptionamount", "redemptiondate", "redemptioncopies", "redemptioniopv"});
            }
            this.getModel().setValue("remark", (Object)String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u8d4e\u56de\u7533\u8bf7", (String)"FinApplyEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]), finSubscribe.get("number")));
            this.getModel().setValue("productno", finSubscribe.get("productno"));
            this.getModel().setValue("productname", finSubscribe.get("name"));
            this.getModel().setValue("investvarieties", finSubscribe.get("investvarieties"));
            this.getModel().setValue("productfactory", finSubscribe.get("productfactory"));
            this.getModel().setValue("finorginfo", finSubscribe.get("finorginfo"));
            this.getModel().setValue("finaccount", finSubscribe.get("finaccount"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"finaccountf7", (Object)finSubscribe.get("finaccountf7"));
            this.getModel().setValue("settleaccount", finSubscribe.get("settleaccount"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"valuedate", (Object)finSubscribe.get("valuedate"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)finSubscribe.get("expiredate"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)finSubscribe.get("term"));
            this.getModel().setValue("amount", finSubscribe.get("amount"));
            this.getModel().setValue("buycopies", finSubscribe.get("buycopies"));
            this.getModel().setValue("iopv", finSubscribe.get("iopv"));
            this.getModel().setValue("revenuetype", finSubscribe.get("revenuetype"));
            this.getModel().setValue("planrevenue", finSubscribe.get("planrevenue"));
            this.getModel().setValue("floatplanrevenue", finSubscribe.get("floatplanrevenue"));
            this.getModel().setValue("basis", finSubscribe.get("basis"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intdate", (Object)finSubscribe.get("intdate"));
            this.getModel().setValue("redeempattern", finSubscribe.get("redeempattern"));
            this.getModel().setValue("bonusway", finSubscribe.get("bonusway"));
            this.getModel().setValue("revenueproject", finSubscribe.get("revenueproject"));
            this.getModel().setValue("risklevel", finSubscribe.get("risklevel"));
            this.getModel().setValue("explain", finSubscribe.get("explain"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"product", (Object)finSubscribe.getDynamicObject("product"));
            this.callPlanAmount();
        }
    }

    private void setMustInputProps() {
        DynamicObject finSubscribe = (DynamicObject)this.getModel().getValue("finsubscribe");
        if (EmptyUtil.isNoEmpty((DynamicObject)finSubscribe)) {
            String redeemWay = finSubscribe.getString("redeemway");
            if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"redemptioncopies", "redemptioniopv"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"redemptionamount", "redemptiondate"});
            } else if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"revenuetype"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"redemptionamount", "redemptiondate", "redemptioncopies", "redemptioniopv"});
            }
        }
    }

    private void checkCopies(BeforeFieldPostBackEvent e) {
        Object newVal = e.getValue();
        if (EmptyUtil.isEmpty((Object)newVal)) {
            return;
        }
        if (!RedeemWayEnum.copies_redeem.getValue().equals(this.getModel().getValue("redeemway"))) {
            return;
        }
        BigDecimal surplusCopies = Optional.ofNullable((DynamicObject)this.getModel().getValue("finsubscribe")).map(r -> r.getBigDecimal("surpluscopies")).orElse(BigDecimal.ZERO);
        if (EmptyUtil.isEmpty((BigDecimal)surplusCopies)) {
            return;
        }
        BigDecimal copies = new BigDecimal(String.valueOf(newVal));
        if (copies.compareTo(surplusCopies) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d4e\u56de\u4efd\u6570\u4e0d\u5141\u8bb8\u8d85\u8fc7\u7406\u8d22\u5269\u4f59\u4efd\u6570\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RedeemBillEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView(e.getKey());
        }
    }

    private void calAmount() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal buyCopies = (BigDecimal)this.getModel().getValue("redemptioncopies");
            BigDecimal iopv = (BigDecimal)this.getModel().getValue("redemptioniopv");
            BigDecimal amount = iopv.multiply(buyCopies);
            this.getModel().setValue("redemptionamount", (Object)amount);
            this.getView().updateView("redemptionamount");
        }
    }

    private void loadSchemeCardInfo() {
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        List<Long> schemeIds = entrys.stream().map(v -> v.getLong("e_schemeid")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(schemeIds)) {
            this.createSchemeCard(schemeIds);
            if (this.getModel().getEntryRowCount("s_entry") > 0) {
                ((CardEntry)this.getControl("s_entry")).selectCard(Integer.valueOf(0));
            }
        }
    }

    private void createSchemeCard(List<Long> schemeIds) {
        DynamicObject[] finSchemes = TmcDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_finscheme"));
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        DynamicObjectCollection cardEntrys = this.getModel().getEntryEntity("s_entry");
        cardEntrys.clear();
        Map dataMap = Arrays.stream(finSchemes).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        for (DynamicObject row : entry) {
            DynamicObject finScheme = (DynamicObject)dataMap.get(row.get("e_schemeid"));
            if (EmptyUtil.isEmpty((DynamicObject)finScheme)) continue;
            DynamicObject cardEntry = cardEntrys.addNew();
            cardEntry.set("s_productno", (Object)finScheme.getString("productno"));
            cardEntry.set("s_name", (Object)finScheme.getString("name"));
            cardEntry.set("s_finorginfo", (Object)finScheme.getDynamicObject("finorginfo"));
            cardEntry.set("s_amount", (Object)finScheme.getBigDecimal("amount"));
            cardEntry.set("s_planamount", (Object)finScheme.getBigDecimal("planamount"));
            cardEntry.set("selecttag", (Object)row.getBoolean("e_isselect"));
            cardEntry.set("s_schemeid", finScheme.getPkValue());
            cardEntry.set("s_number", (Object)finScheme.getString("number"));
            cardEntry.set("s_currency", this.getModel().getValue("currency"));
            DynamicObjectCollection schemeEntry = cardEntry.getDynamicObjectCollection("c_entry");
            DynamicObject newScheme = schemeEntry.addNew();
            DataEntityPropertyCollection properties = newScheme.getDynamicObjectType().getProperties();
            for (IDataEntityProperty prop : properties) {
                String propName = prop.getName();
                if (!propName.startsWith("c_")) continue;
                if (StringUtils.equals((CharSequence)"c_explain", (CharSequence)propName)) {
                    newScheme.set(propName, finScheme.get("comment"));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"c_schemeid", (CharSequence)propName)) {
                    newScheme.set(propName, (Object)finScheme.getLong("id"));
                    continue;
                }
                newScheme.set(propName, finScheme.get(propName.replace("c_", "")));
            }
        }
        this.getModel().setDataChanged(false);
        this.getView().updateView("s_entry");
    }

    private void setFinSubscribeFilter(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            QFilter qFilter = new QFilter("org", "=", org.getPkValue());
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdCollection = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("org.id", "in", (Object)orgIdCollection.toArray());
        listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private void setCurrencyEnable() {
        boolean notEnable = (Boolean)this.getModel().getValue("inquiry");
        if (!notEnable) {
            this.getView().setEnable(Boolean.valueOf(!notEnable), new String[]{"currency"});
        } else {
            this.getModel().setValue("product", null);
        }
    }

    private void setProduct() {
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        Object supermarketId = paraMap.get("supermarketid");
        if (EmptyUtil.isEmpty(supermarketId)) {
            return;
        }
        this.getModel().setValue("product", supermarketId);
    }

    private void callPlanAmount() {
        String applyType = (String)this.getModel().getValue("applytype");
        if (FinApplyTypeEnum.REDEEM.getValue().equals(applyType)) {
            BigDecimal planAmount = RedeemBillHelper.calPlanAmountForRedeem((DynamicObject)this.getModel().getDataEntity());
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"planamount", (Object)planAmount);
        }
    }

    private void checkRedemptionDate(BeforeFieldPostBackEvent e) {
        Object newVal = e.getValue();
        Date valueDate = (Date)this.getModel().getValue("valuedate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{newVal, valueDate})) {
            return;
        }
        Date redemptionDate = DateUtils.stringToDate((String)String.valueOf(newVal), (String)"yyyy-MM-dd");
        if (valueDate.after(redemptionDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d4e\u56de\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u7406\u8d22\u5f00\u59cb\u65e5\u3002", (String)"RedeemBillEdit_7", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView(e.getKey());
        }
    }
}

