/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.common;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.AgreeDepositStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class AgreeDepositHelper {
    public static void setIntObjF7Filter(BeforeF7SelectEvent evt) {
        List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        List<Long> usedBankAcctIds = AgreeDepositHelper.getUsedBankAcctIds();
        qFilters.add(new QFilter("intobject", "not in", usedBankAcctIds));
    }

    public static void setBankAcctF7Filter(BeforeF7SelectEvent evt, DynamicObject org) {
        List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        QFilter acctFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)org.getLong("id"));
        qFilters.add(acctFilter);
        List<Long> usedBankAcctIds = AgreeDepositHelper.getUsedBankAcctIds();
        qFilters.add(new QFilter("id", "not in", usedBankAcctIds));
    }

    private static List<Long> getUsedBankAcctIds() {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and(new QFilter("status", "=", (Object)AgreeDepositStatusEnum.NORMAL.getValue()));
        DynamicObjectCollection agreeBills = QueryServiceHelper.query((String)"cim_agreement_deposit", (String)"bankacct", (QFilter[])new QFilter[]{qFilter});
        return agreeBills.stream().map(r -> r.getLong("bankacct")).collect(Collectors.toList());
    }

    public static void setBankColumnNull(PropertyChangedArgs e, IDataModel model) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (EmptyUtil.isNoEmpty((Object)newValue)) {
            model.setValue("bankacct", null);
        }
    }

    public static void setCurrencyByBankAcct(IDataModel model) {
        DynamicObject bankAcct = (DynamicObject)model.getValue("bankacct");
        if (EmptyUtil.isNoEmpty((DynamicObject)bankAcct)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"currency", (Object)bankAcct.getDynamicObject("defaultcurrency"));
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"finorginfo", (Object)bankAcct.getDynamicObject("bank"));
        }
    }

    public static Pair<BigDecimal, BigDecimal> getAmtAndBpPoint(DynamicObject intObj) {
        BigDecimal depositAmt = BigDecimal.ZERO;
        BigDecimal bpPoint = BigDecimal.ZERO;
        DynamicObjectCollection intEntry = intObj.getDynamicObjectCollection("depositint_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)intEntry)) {
            return Pair.of((Object)depositAmt, (Object)bpPoint);
        }
        if (intEntry.size() >= 2) {
            DynamicObject secondRow = (DynamicObject)intEntry.get(1);
            depositAmt = secondRow.getBigDecimal("depositamtbegin");
            bpPoint = secondRow.getBigDecimal("intfloatpoint");
        } else {
            depositAmt = ((DynamicObject)intEntry.get(0)).getBigDecimal("depositamtend");
        }
        return Pair.of((Object)depositAmt, (Object)bpPoint);
    }
}

