/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.convert;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.enums.ExpireRedepositTypeEnum;
import kd.tmc.cim.common.enums.RateSignEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RateResetEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositApply2DepositDealConvertPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String targetEntity = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntity)) {
            DynamicObject depositBill = dataEntity.getDataEntity();
            Long srcId = (Long)depositBill.get("sourcebillid");
            DynamicObject depositApply = TmcDataServiceHelper.loadSingle((Object)srcId, (String)this.getSrcMainType().getName());
            depositBill.set("apply", (Object)depositApply);
            String tradeChannel = depositApply.getString("tradechannel");
            String intType = depositBill.getString("interesttype");
            if (StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)intType)) {
                depositBill.set("interestrate", null);
                depositBill.set("rateadjuststyle", (Object)RateResetEnum.deadline.getValue());
                if (EmptyUtil.isEmpty((String)depositBill.getString("ratesign"))) {
                    depositBill.set("ratesign", (Object)RateSignEnum.ADD.getValue());
                }
            } else if (StringUtils.equals((CharSequence)InterestTypeEnum.FIXED.getValue(), (CharSequence)intType)) {
                depositBill.set("referencerate", null);
                depositBill.set("ratesign", null);
                depositBill.set("ratefloatpoint", null);
                depositBill.set("rateadjuststyle", null);
                if (!TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
                    depositBill.set("deadline", null);
                }
            }
            String applyType = depositApply.getString("applytype");
            if (DepositApplyTypeEnum.SUBSIST.getValue().equals(applyType)) {
                Date expireDateNew;
                DynamicObject deposit = depositApply.getDynamicObject("deposit");
                DynamicObject srcDepositBill = TmcDataServiceHelper.loadSingle((Object)deposit.getPkValue(), (String)"cim_deposit", (String)"expireredeposit,surplusamount,planamount,totalamount,revenueproject,expireredeposit");
                depositBill.set("srcprincipal", (Object)srcDepositBill.getBigDecimal("surplusamount"));
                BigDecimal planAmount = depositApply.getBigDecimal("profitamount");
                depositBill.set("srcinterest", (Object)planAmount);
                if (ExpireRedepositTypeEnum.PRINCIPALINTREDEPOSIT.getValue().equals(depositApply.getString("expireredeposit"))) {
                    BigDecimal surplusAmount = srcDepositBill.getBigDecimal("surplusamount");
                    depositBill.set("amount", (Object)surplusAmount.add(planAmount));
                }
                Date expireDate = depositApply.getDate("expiredate");
                depositBill.set("intdate", (Object)expireDate);
                depositBill.set("expireredeposit", (Object)depositApply.getString("expireredeposit"));
                if (!TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
                    String term = depositApply.getString("term");
                    expireDateNew = TermHelper.getDateByBaseDate4ymd((String)term, (Date)expireDate);
                    depositBill.set("expiredate", (Object)expireDateNew);
                } else {
                    String deadLine = depositApply.getString("deadline");
                    expireDateNew = DepositHelper.calEndDate((Date)expireDate, (String)deadLine);
                    depositBill.set("expiredate", (Object)expireDateNew);
                }
                Optional.ofNullable(srcDepositBill.getDynamicObject("revenueproject")).ifPresent(r -> depositBill.set("revenueproject", r));
                depositBill.set("srcexpireredeposit", (Object)ExpireRedepositTypeEnum.PRINCIPALREDEPOSIT.getValue());
                if (!ExpireRedepositTypeEnum.isPrincipalInt((String)srcDepositBill.getString("expireredeposit"))) continue;
                depositBill.set("srcexpireredeposit", (Object)ExpireRedepositTypeEnum.PRINCIPALINTREDEPOSIT.getValue());
                continue;
            }
            if (!DepositApplyTypeEnum.RELEASE.getValue().equals(applyType)) continue;
            depositBill.set("expireredeposit", (Object)depositApply.getString("expireredeposit"));
        }
    }
}

