/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.convert;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.tmc.cim.common.bean.RevenueConvertParam;
import kd.tmc.cim.formplugin.convert.revenueconvert.AbstractRevenueConvert;
import kd.tmc.cim.formplugin.convert.revenueconvert.FromAutoRevenueConvert;
import kd.tmc.cim.formplugin.convert.revenueconvert.FromBatchRevenueConvert;
import kd.tmc.cim.formplugin.convert.revenueconvert.FromDepositRevenueConvert;
import kd.tmc.cim.formplugin.convert.revenueconvert.FromRedepositRevenueConvert;
import kd.tmc.cim.formplugin.convert.revenueconvert.FromReleaseRevenueConvert;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositDeal2RevenueConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        AbstractRevenueConvert convert;
        RevenueConvertParam convertParam;
        Map opMap = this.getOption().getVariables();
        String entityName = this.getTgtMainType().getName();
        ExtendedDataEntity[] dataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(entityName);
        List<DynamicObject> revenues = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        String paramJson = (String)opMap.get("const_operate_params");
        if (EmptyUtil.isNoEmpty((String)paramJson)) {
            convertParam = (RevenueConvertParam)SerializationUtils.fromJsonString((String)paramJson, RevenueConvertParam.class);
        } else {
            String operate = (String)opMap.get("const_operate_var");
            convertParam = new RevenueConvertParam(EmptyUtil.isNoEmpty((String)operate) ? operate : "");
            RevenueConvertParam.SourceParam sourceParam = new RevenueConvertParam.SourceParam(Long.valueOf(((DynamicObject)revenues.get(0)).getLong("sourcebillid")));
            sourceParam.getOption().putAll(opMap);
            convertParam.addParam(sourceParam);
        }
        switch (convertParam.getOperateSource()) {
            case "fromRelease": {
                convert = new FromReleaseRevenueConvert();
                break;
            }
            case "fromRedeposit": {
                convert = new FromRedepositRevenueConvert();
                break;
            }
            case "fromBatch": {
                convert = new FromBatchRevenueConvert();
                break;
            }
            case "fromAutoRevenue": {
                convert = new FromAutoRevenueConvert();
                break;
            }
            default: {
                convert = new FromDepositRevenueConvert();
            }
        }
        convert.convert(revenues, convertParam);
    }
}

