/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.convert.revenueconvert;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.cim.common.enums.ExpireRedepositTypeEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.formplugin.convert.revenueconvert.IRevenueConvert;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractRevenueConvert
implements IRevenueConvert {
    protected void calcRealRate(DynamicObject revenue) {
        BigDecimal revenueAmt = revenue.getBigDecimal("actpreinstamt");
        DynamicObjectCollection rows = revenue.getDynamicObjectCollection("entrys");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{revenueAmt, rows})) {
            revenue.set("realrate", null);
            return;
        }
        revenue.set("realrate", (Object)DepositHelper.calcRealRate((DynamicObjectCollection)rows, (BigDecimal)revenueAmt));
    }

    protected void dealByClickRevenueButton(DynamicObject revenue, DynamicObject deposit, Map<String, String> opMap) {
        String expireRedeposit;
        String fromInitFlag;
        Date startDate = DepositHelper.getIntCalcStartDate((DynamicObject)deposit);
        revenue.set("prestartdate", (Object)startDate);
        Date endDate = Optional.ofNullable(revenue.getDate("bizdate")).orElseGet(DateUtils::getCurrentDate);
        if (endDate.compareTo(startDate) < 0) {
            revenue.set("bizdate", (Object)DateUtils.getNextDay((Date)startDate, (int)1));
            endDate = revenue.getDate("bizdate");
        }
        if (EmptyUtil.isNoEmpty((String)(fromInitFlag = opMap.get("from_init_bill")))) {
            startDate = deposit.getDate("intdate");
            revenue.set("prestartdate", (Object)startDate);
            revenue.set("lastrevenuedate", null);
            endDate = DateUtils.stringToDate((String)opMap.get("bizdate"), (String)"yyyyMMdd");
            revenue.set("bizdate", (Object)endDate);
            revenue.set("isinit", (Object)Boolean.TRUE);
            revenue.set("revenuesort", (Object)opMap.get("revenuesort"));
        }
        if (EmptyUtil.isNoEmpty((String)(expireRedeposit = opMap.get("expireredeposit"))) && ExpireRedepositTypeEnum.PRINCIPALINTREDEPOSIT.getValue().equals(expireRedeposit)) {
            revenue.set("recaccountf7", (Object)deposit.getDynamicObject("finaccountf7"));
            revenue.set("recaccount", (Object)deposit.getString("finaccount"));
        }
        IntBillInfo intBillInfo = DepositHelper.calcDepositBillInt((DynamicObject)deposit, (Date)startDate, (Date)endDate);
        DepositHelper.setRevenueEntry((DynamicObject)revenue, (IntBillInfo)intBillInfo);
        if (EmptyUtil.isNoEmpty((String)fromInitFlag)) {
            revenue.set("actpreinstamt", (Object)opMap.get("actpreinstamt"));
        }
    }
}

