/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.convert.revenueconvert;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.tmc.cim.common.bean.RevenueConvertParam;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.formplugin.convert.revenueconvert.AbstractRevenueConvert;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FromAutoRevenueConvert
extends AbstractRevenueConvert {
    @Override
    public void convert(List<DynamicObject> revenues, RevenueConvertParam convertParam) {
        List depositIds = revenues.stream().filter(d -> EmptyUtil.isNoEmpty((Long)d.getLong("sourcebillid"))).map(d -> d.getLong("sourcebillid")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(depositIds)) {
            return;
        }
        DynamicObject[] deposits = TmcDataServiceHelper.load((Object[])depositIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_deposit"));
        Map<Long, DynamicObject> depositMap = Arrays.stream(deposits).collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
        Map sourceParamMap = convertParam.getSourceParamMap();
        for (DynamicObject revenue : revenues) {
            long sourceBillId = revenue.getLong("sourcebillid");
            DynamicObject depositBill = depositMap.get(sourceBillId);
            this.dealByAutoRevenue(revenue, depositBill, ((RevenueConvertParam.SourceParam)sourceParamMap.get(sourceBillId)).getOption());
            this.calcRealRate(revenue);
        }
    }

    private void dealByAutoRevenue(DynamicObject revenue, DynamicObject depositBill, Map<String, String> opMap) {
        Date planRevDate = DateUtils.stringToDate((String)opMap.get("bizdate"), (String)"yyyy-MM-dd");
        revenue.set("bizdate", (Object)planRevDate);
        revenue.set("revenuesort", (Object)RevenueSortEnum.revenue.getValue());
        DynamicObjectCollection revenueEntry = revenue.getDynamicObjectCollection("entrys");
        revenueEntry.clear();
        IntBillInfo intBillInfo = DepositHelper.calcDepositBillInt((DynamicObject)depositBill, (Date)DepositHelper.getIntCalcStartDate((DynamicObject)depositBill), (Date)planRevDate);
        if (EmptyUtil.isEmpty((Object)intBillInfo) || EmptyUtil.isEmpty((Collection)intBillInfo.getDetails())) {
            return;
        }
        List details = intBillInfo.getDetails();
        for (IntBillDetailInfo detail : details) {
            DynamicObject revenueRow = revenueEntry.addNew();
            revenueRow.set("inststartdate", (Object)detail.getBeginDate());
            revenueRow.set("instenddate", (Object)detail.getEndDate());
            revenueRow.set("instdays", (Object)detail.getDays());
            revenueRow.set("instprincipalamt", (Object)detail.getPrinciple());
            revenueRow.set("rate", (Object)detail.getRate());
            revenueRow.set("ratetrandays", (Object)detail.getBasisDay());
            revenueRow.set("instamt", (Object)detail.getAmount());
        }
        revenue.set("prestartdate", (Object)((IntBillDetailInfo)details.get(0)).getBeginDate());
        revenue.set("prestenddate", (Object)((IntBillDetailInfo)details.get(details.size() - 1)).getEndDate());
        BigDecimal planAmt = intBillInfo.getAmount();
        revenue.set("predictpreinstamt", (Object)planAmt);
        revenue.set("actpreinstamt", (Object)planAmt);
    }
}

