/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.convert.revenueconvert;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.tmc.cim.common.bean.RevenueConvertParam;
import kd.tmc.cim.common.enums.ExpireRedepositTypeEnum;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.formplugin.convert.revenueconvert.AbstractRevenueConvert;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FromRedepositRevenueConvert
extends AbstractRevenueConvert {
    @Override
    public void convert(List<DynamicObject> revenues, RevenueConvertParam convertParam) {
        List depositIds = revenues.stream().filter(d -> EmptyUtil.isNoEmpty((Long)d.getLong("sourcebillid"))).map(d -> d.getLong("sourcebillid")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(depositIds)) {
            return;
        }
        DynamicObject[] deposits = TmcDataServiceHelper.load((Object[])depositIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_deposit"));
        Map<Long, DynamicObject> depositMap = Arrays.stream(deposits).collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
        Map sourceParamMap = convertParam.getSourceParamMap();
        for (DynamicObject revenue : revenues) {
            long sourceBillId = revenue.getLong("sourcebillid");
            DynamicObject depositBill = depositMap.get(sourceBillId);
            RevenueConvertParam.SourceParam sourceParam = (RevenueConvertParam.SourceParam)sourceParamMap.get(sourceBillId);
            this.dealByRedepositBill(revenue, depositBill, sourceParam.getOption());
            this.calcRealRate(revenue);
        }
    }

    private void dealByRedepositBill(DynamicObject revenue, DynamicObject deposit, Map<String, String> opMap) {
        revenue.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        revenue.set("bizdate", (Object)DateUtils.stringToDate((String)opMap.get("bizdate"), (String)"yyyy-MM-dd"));
        revenue.set("revenuesort", (Object)RevenueSortEnum.redeposit_revenue.getValue());
        String expireRedeposit = opMap.get("expireredeposit");
        if (EmptyUtil.isNoEmpty((String)expireRedeposit) && ExpireRedepositTypeEnum.isPrincipalInt((String)expireRedeposit)) {
            revenue.set("expireredeposit", (Object)ExpireRedepositTypeEnum.PRINCIPALINTREDEPOSIT.getValue());
        } else {
            revenue.set("expireredeposit", (Object)ExpireRedepositTypeEnum.PRINCIPALREDEPOSIT.getValue());
        }
        if (EmptyUtil.isNoEmpty((String)opMap.get("ishistorybuild"))) {
            revenue.set("ishistorybuild", (Object)Boolean.TRUE);
        }
        this.dealByClickRevenueButton(revenue, deposit, opMap);
        String actInstAmt = opMap.get("actpreinstamt");
        if (EmptyUtil.isNoEmpty((String)actInstAmt) && new BigDecimal(actInstAmt).compareTo(BigDecimal.ZERO) > 0) {
            revenue.set("actpreinstamt", (Object)opMap.get("actpreinstamt"));
        }
    }
}

