/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.convert.revenueconvert;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.bean.RevenueConvertParam;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.formplugin.convert.revenueconvert.AbstractRevenueConvert;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FromReleaseRevenueConvert
extends AbstractRevenueConvert {
    @Override
    public void convert(List<DynamicObject> revenues, RevenueConvertParam convertParam) {
        Map sourceParamMap = convertParam.getSourceParamMap();
        Set releaseIds = convertParam.getParams().stream().filter(d -> EmptyUtil.isNoEmpty((String)d.getValue("srcreleaseid"))).map(d -> Long.parseLong(d.getValue("srcreleaseid"))).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(releaseIds)) {
            return;
        }
        DynamicObject[] releaseBills = TmcDataServiceHelper.load((Object[])releaseIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_release"));
        Map<Long, DynamicObject> releaseBillMap = Arrays.stream(releaseBills).collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
        for (DynamicObject revenue : revenues) {
            RevenueConvertParam.SourceParam sourceParam = (RevenueConvertParam.SourceParam)sourceParamMap.get(revenue.getLong("sourcebillid"));
            Long releaseBillId = Long.parseLong(sourceParam.getValue("srcreleaseid"));
            DynamicObject releaseBill = releaseBillMap.get(releaseBillId);
            this.dealByReleaseBill(revenue, releaseBill, sourceParam.getOption());
            this.calcRealRate(revenue);
        }
    }

    private void dealByReleaseBill(DynamicObject revenue, DynamicObject releaseBill, Map<String, String> opMap) {
        revenue.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        revenue.set("srcreleaseid", (Object)opMap.get("srcreleaseid"));
        revenue.set("bizdate", (Object)DateUtils.stringToDate((String)opMap.get("bizdate"), (String)"yyyy-MM-dd"));
        revenue.set("revenuesort", (Object)RevenueSortEnum.redeem_revenue.getValue());
        if (EmptyUtil.isNoEmpty((String)opMap.get("ishistorybuild"))) {
            revenue.set("ishistorybuild", (Object)Boolean.TRUE);
        }
        this.cloneReleaseEntry2RevenueEntry(releaseBill, revenue);
        this.dealSdkForRelease2Revenue(revenue, opMap);
    }

    private void cloneReleaseEntry2RevenueEntry(DynamicObject releaseBill, DynamicObject revenue) {
        revenue.set("demandrate", (Object)releaseBill.getBigDecimal("demandrate"));
        revenue.set("predictpreinstamt", (Object)releaseBill.getBigDecimal("predictinstamt"));
        revenue.set("actpreinstamt", (Object)releaseBill.getBigDecimal("realrevenue"));
        revenue.set("combineinst", (Object)releaseBill.getBoolean("combineinst"));
        DynamicObject releaseRecAcct = releaseBill.getDynamicObject("finaccountf7");
        if (EmptyUtil.isNoEmpty((DynamicObject)releaseRecAcct)) {
            revenue.set("recaccountf7", (Object)releaseRecAcct);
            revenue.set("recaccount", (Object)releaseRecAcct.getString("number"));
        }
        DynamicObjectCollection revenueEntry = revenue.getDynamicObjectCollection("entrys");
        revenueEntry.clear();
        DynamicObjectCollection releaseEntry = releaseBill.getDynamicObjectCollection("entrys");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)releaseEntry)) {
            return;
        }
        for (DynamicObject releaseRow : releaseEntry) {
            DynamicObject revenueRow = revenueEntry.addNew();
            revenueRow.set("inststartdate", (Object)releaseRow.getDate("estartdate"));
            revenueRow.set("instenddate", (Object)releaseRow.getDate("eenddate"));
            revenueRow.set("instdays", (Object)releaseRow.getInt("edays"));
            revenueRow.set("instprincipalamt", (Object)releaseRow.getBigDecimal("efinamount"));
            revenueRow.set("rate", (Object)releaseRow.getBigDecimal("eplanrevenue"));
            revenueRow.set("ratetrandays", (Object)releaseRow.getInt("econvertdays"));
            revenueRow.set("instamt", (Object)releaseRow.getBigDecimal("erevenueamount"));
        }
        revenue.set("prestartdate", (Object)((DynamicObject)releaseEntry.get(0)).getDate("estartdate"));
        revenue.set("prestenddate", (Object)((DynamicObject)releaseEntry.get(releaseEntry.size() - 1)).getDate("eenddate"));
    }

    private void dealSdkForRelease2Revenue(DynamicObject revenue, Map<String, String> opMap) {
        String sdkStr = opMap.get("SecondDevFieldVal");
        if (EmptyUtil.isEmpty((String)sdkStr)) {
            return;
        }
        Map sdkMap = (Map)JSON.parseObject((String)sdkStr, Map.class);
        for (Map.Entry propVal : sdkMap.entrySet()) {
            String keyProp = (String)propVal.getKey();
            Object value = propVal.getValue();
            DynamicProperty property = revenue.getDynamicObjectType().getProperty(keyProp);
            try {
                if (property instanceof BasedataProp) {
                    String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                    DynamicObject ActVal = TmcDataServiceHelper.loadSingle(value, (String)baseEntityId);
                    revenue.set(keyProp, (Object)ActVal);
                    continue;
                }
                revenue.set(keyProp, value);
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e2d\u6ca1\u6709%s\u5c5e\u6027\u3002", (String)"DepositDeal2RevenueConvertPlugin_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]), keyProp));
            }
        }
    }
}

