/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public abstract class AbstractReleaseList
extends AbstractTmcListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        DepositHelper.removeSpareFilter((FilterContainerInitArgs)args, (String)((BillList)this.getControl("billlistap")).getBillFormId());
        List filterColumns = args.getCommonFilterColumns();
        String clearSubmitTime = (String)this.getView().getFormShowParameter().getCustomParam("clearSubmitTime");
        for (FilterColumn filterColumn : filterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)"org.name", (CharSequence)fieldName) && (!"true".equals(clearSubmitTime) || !"submittime".equals(fieldName) && !"redeemdate".equals(fieldName))) continue;
            filterColumn.setDefaultValue("");
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("investvarieties.investtype", "in", (Object)this.chooseInvestType()));
        BillList billList = (BillList)this.getControl("billlistap");
        if (!billList.getBillFormId().startsWith("ifm")) {
            QFilter filter = DepositHelper.isCimRelateAppSet() ? new QFilter("finorginfo.finorgtype.type", "=", (Object)"1").and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).or(new QFilter("finorginfo.finorgtype.type", "!=", (Object)"1")) : new QFilter("finorginfo.finorgtype.type", "!=", (Object)"1");
            e.getQFilters().add(filter);
        }
    }

    protected List<QFilter> addCustomFilterForFilterCol(String fieldName) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        if (StringUtils.equals((CharSequence)"finorginfo.name", (CharSequence)fieldName)) {
            QFilter depositFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            depositFilter.and(new QFilter("investvarieties.investtype", "in", (Object)this.chooseInvestType()));
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.chooseDepositFormId(), (String)"finorginfo", (QFilter[])depositFilter.toArray(), null);
            Iterator iterator = dataSet.distinct().iterator();
            HashSet<Object> pkIdSet = new HashSet<Object>();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                pkIdSet.add(row.get("finorginfo"));
            }
            filters.add(new QFilter("id", "in", pkIdSet));
        }
        return filters;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "pushandsaverec": {
                this.validateBeforePushRec(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (EmptyUtil.isEmpty((Object)operationResult) || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "commitbe": 
            case "recommitbe": 
            case "drawconfirm": {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refreshData();
                break;
            }
        }
    }

    private void validateBeforePushRec(BeforeDoOperationEventArgs args) {
        List selectedIdList = this.getSelectedIdList();
        if (EmptyUtil.isEmpty((Collection)selectedIdList)) {
            return;
        }
        DynamicObjectCollection releases = QueryServiceHelper.query((String)"cim_release", (String)"billstatus,billno,tradechannel,accountdate", (QFilter[])new QFilter("id", "in", (Object)selectedIdList).toArray());
        long billStatNum = releases.stream().map(r -> r.getString("billstatus")).filter(r -> BillStatusEnum.isAudit((String)r)).count();
        if (billStatNum != (long)selectedIdList.size()) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u7684\u5355\u636e\u3002", (String)"AbstractReleaseList_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        }
        StringJoiner errorNUmbers = new StringJoiner("\u3001");
        releases.stream().filter(v -> StringUtils.equals((CharSequence)v.getString("tradechannel"), (CharSequence)TradeChannelEnum.ONLINE.getValue())).filter(v -> EmptyUtil.isEmpty((Object)v.getDate("accountdate"))).forEach(v -> errorNUmbers.add(v.getString("billno")));
        if (errorNUmbers.length() > 0) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e%s\u89e3\u6d3b\u8fd8\u672a\u5230\u8d26\u3002", (String)"AbstractReleaseList_0", (String)"tmc-cim-formplugin", (Object[])new Object[]{errorNUmbers}));
        }
    }

    public abstract String chooseDepositFormId();

    public abstract String[] chooseInvestType();
}

