/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.enums.DepositTermEnum;
import kd.tmc.cim.common.enums.ExpireRedepositTypeEnum;
import kd.tmc.cim.common.enums.PreNoticeDayEnum;
import kd.tmc.cim.common.enums.RateSignEnum;
import kd.tmc.cim.common.enums.ReleaseTypeEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositApplyEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit deposit = (BasedataEdit)this.getControl("deposit");
        deposit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit referenceRate = (BasedataEdit)this.getControl("referencerate");
        referenceRate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit investVarieties = (BasedataEdit)this.getControl("investvarieties");
        investVarieties.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldName;
        switch (fieldName = evt.getProperty().getName()) {
            case "deposit": {
                this.setDepositFilter(evt);
                break;
            }
            case "org": {
                this.setOrgFilter(evt);
                break;
            }
            case "referencerate": {
                this.setReferenceRateFilter(evt);
                break;
            }
            case "investvarieties": {
                this.setInvestVarietiesFilter(evt);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setReleaseDefaultValues();
        this.setDefaultValues();
        this.setDefaultValue();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showSchemeSelectView();
        this.setMustInputByApplyType();
        this.setInterestTypeParameter();
        this.setEnableValueByDepositF7();
        this.setReleaseType(false);
        this.setExpireReDepositComboItem();
        this.tradeChannelChgEvt(true);
        this.setViewRule();
        this.setLastAmountColumnVisible();
        this.setSumAmountEvt();
        this.setMustInputSpecialScene();
        this.setInterestTypeEnum();
        DepositHelper.setInterestRateShowName((IFormView)this.getView());
    }

    private void showSchemeSelectView() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (kd.tmc.cim.common.util.StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.SAVE.getValue())) {
            this.inquiryChgEvt();
        } else {
            boolean inQuiry = (Boolean)this.getModel().getValue("inquiry");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ds_schemeinfo"});
            this.getView().setVisible(Boolean.valueOf(!inQuiry), new String[]{"applyinfoap"});
            this.getView().setVisible(Boolean.valueOf(inQuiry), new String[]{"advconap"});
            if (kd.tmc.cim.common.util.StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.SUBMIT.getValue())) {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                this.getView().setEnable(Boolean.valueOf(EmptyUtil.isNoEmpty(customParams.get("SCENE")) || EmptyUtil.isNoEmpty(customParams.get("fromselect"))), new String[]{"entry"});
                this.getView().setVisible(Boolean.valueOf(EmptyUtil.isNoEmpty(customParams.get("fromselect"))), new String[]{"bar_savescheme"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (kd.tmc.cim.common.util.StringUtils.equals((CharSequence)"audit", (CharSequence)evt.getOperateKey()) && evt.getOperationResult().isSuccess()) {
            this.setLastAmountColumnVisible();
        }
        if (Arrays.asList("submit", "unsubmit", "unaudit").contains(evt.getOperateKey()) && evt.getOperationResult().isSuccess()) {
            this.getView().updateView();
            this.getModel().setDataChanged(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName;
        super.propertyChanged(e);
        switch (fieldName = e.getProperty().getName()) {
            case "applytype": {
                this.setMustInputByApplyType();
                this.setReleaseDefaultValues();
                this.setExpireReDepositComboItem();
                this.setExpireReDepositDefValue();
                this.cleanPropValues();
                this.applyTypeChgEvt();
                break;
            }
            case "deposit": {
                this.setValueByDeposit();
                break;
            }
            case "interesttype": {
                this.setInterestTypeParameter();
                this.interestTypeChgEvt();
                break;
            }
            case "intdate": 
            case "term": 
            case "deadline": {
                this.calExpireDate((String)this.getModel().getValue("tradechannel"));
                break;
            }
            case "expiredate": {
                this.calTermOrIntDate((String)this.getModel().getValue("tradechannel"));
                break;
            }
            case "tradechannel": {
                this.tradeChannelChgEvt(false);
                break;
            }
            case "investvarieties": {
                DepositHelper.initInterestTypeEnum((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"investvarieties", (String)"interesttype");
                this.investVarietiesChgEvt();
                DepositHelper.setInterestRateShowName((IFormView)this.getView());
                break;
            }
            case "finorginfo": {
                this.finOrgInfoChgEvt();
                break;
            }
            case "estimatedate": {
                this.setReleaseTypeForReleaseApply();
                this.setProfitAmount();
                break;
            }
            case "isrolling": {
                this.isRollingChgEvt();
                break;
            }
            case "inquiry": {
                this.inquiryChgEvt();
                break;
            }
            case "releaseamount": {
                this.setProfitAmount();
                this.setSumAmountEvt();
                break;
            }
            case "profitamount": {
                this.setSumAmountEvt();
                break;
            }
            case "prenoticeday": {
                this.setAccountDay();
                break;
            }
            case "rangemax": 
            case "rangemin": {
                this.setDefaultRate();
                break;
            }
            case "releasetype": {
                this.setProfitAmount();
                this.setSumAmountEvt();
                break;
            }
        }
    }

    private void setValueByDeposit() {
        this.setDepositParameter();
        this.setReleaseType(true);
        this.setEnableValueByDepositF7();
        this.isRollingChgEvt();
        this.setMustInputSpecialScene();
    }

    private void setSumAmountEvt() {
        BigDecimal releaseAmount = (BigDecimal)this.getModel().getValue("releaseamount");
        BigDecimal profitAmount = (BigDecimal)this.getModel().getValue("profitamount");
        if (EmptyUtil.isEmpty((BigDecimal)profitAmount)) {
            this.getModel().setValue("sumamount", (Object)releaseAmount);
        } else if (EmptyUtil.isEmpty((BigDecimal)releaseAmount)) {
            this.getModel().setValue("sumamount", (Object)profitAmount);
        } else {
            this.getModel().setValue("sumamount", (Object)profitAmount.add(releaseAmount));
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        this.verifyInput(key, value, e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            String channel = (String)this.getModel().getValue("tradechannel");
            if (TradeChannelEnum.OFFLINE.getValue().equals(channel)) {
                this.getModel().setValue("deadline", null);
            }
        }
    }

    private void applyTypeChgEvt() {
        String applyType = (String)this.getModel().getValue("applytype");
        HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(1);
        if (DepositApplyTypeEnum.DEPOSIT.getValue().equals(applyType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"deposit"});
            this.getModel().setValue("deposit", null);
            this.getModel().setValue("remark", null);
            props.put("text", new LocaleString(ResManager.loadKDString((String)"\u7533\u8bf7\u4fe1\u606f", (String)"DepositApplyEdit_8", (String)"tmc-cim-formplugin", (Object[])new Object[0])));
        } else {
            this.getModel().setValue("inquiry", (Object)false);
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"deposit"});
            props.put("text", new LocaleString(ResManager.loadKDString((String)"\u7533\u8bf7\u4fe1\u606f", (String)"DepositApplyEdit_8", (String)"tmc-cim-formplugin", (Object[])new Object[0])));
        }
        this.getView().updateControlMetadata("applyinfoap", props);
    }

    private void inquiryChgEvt() {
        boolean inquiry = (Boolean)this.getModel().getValue("inquiry");
        if (inquiry) {
            this.loadSchemeCardInfo();
        } else {
            this.getModel().deleteEntryData("s_entry");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"ratesign", (Object)RateSignEnum.ADD.getValue());
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
        this.getView().setVisible(Boolean.valueOf(!inquiry), new String[]{"applyinfoap"});
        this.getView().setVisible(Boolean.valueOf(inquiry), new String[]{"ds_schemeinfo"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!inquiry ? 1 : 0) != 0, (String[])new String[]{"tradechannel", "org", "finorginfo", "investvarieties", "currency", "amount", "interesttype"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)inquiry, (String[])new String[]{"c_tradechannel", "c_org", "c_finorginfo", "c_investvarieties", "c_currency", "c_amount", "c_interesttype", "c_intdate", "c_expiredate"});
    }

    private void loadSchemeCardInfo() {
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            return;
        }
        DynamicObjectCollection entryList = this.getModel().getEntryEntity("entry");
        List<Long> schemeIds = entryList.stream().map(v -> v.getLong("e_schemeid")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(schemeIds)) {
            this.createSchemeCard(schemeIds);
            if (this.getModel().getEntryRowCount("s_entry") > 0) {
                ((CardEntry)this.getControl("s_entry")).selectCard(Integer.valueOf(0));
            }
        }
    }

    private void createSchemeCard(List<Long> schemeIds) {
        DynamicObjectCollection depositSchemeIds = QueryServiceHelper.query((String)"cim_depositscheme", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", schemeIds)});
        DynamicObject[] depositSchemes = TmcDataServiceHelper.load((Object[])depositSchemeIds.stream().map(d -> d.get("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_depositscheme"));
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        Map dataMap = Arrays.stream(depositSchemes).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        DynamicObjectCollection cardEntryList = this.getModel().getEntryEntity("s_entry");
        cardEntryList.clear();
        for (DynamicObject row : entry) {
            DynamicObject depositScheme;
            Object schemeId = row.get("e_schemeid");
            if (EmptyUtil.isEmpty((Object)schemeId) || null == (depositScheme = (DynamicObject)dataMap.get(schemeId))) continue;
            DynamicObject cardEntry = cardEntryList.addNew();
            cardEntry.set("s_investvarieties", (Object)depositScheme.getDynamicObject("investvarieties"));
            cardEntry.set("s_finorginfo", (Object)depositScheme.getDynamicObject("finorginfo"));
            cardEntry.set("s_amount", (Object)depositScheme.getBigDecimal("amount"));
            cardEntry.set("s_interestrate", (Object)depositScheme.getBigDecimal("interestrate"));
            cardEntry.set("s_number", (Object)depositScheme.getString("number"));
            cardEntry.set("selecttag", (Object)row.getBoolean("e_isselect"));
            cardEntry.set("s_currency", (Object)depositScheme.getDynamicObject("currency"));
            DynamicObjectCollection schemeEntry = cardEntry.getDynamicObjectCollection("c_entry");
            DynamicObject newScheme = schemeEntry.addNew();
            DataEntityPropertyCollection properties = newScheme.getDynamicObjectType().getProperties();
            for (IDataEntityProperty prop : properties) {
                String propName = prop.getName();
                if (!propName.startsWith("c_")) continue;
                if (StringUtils.equals((CharSequence)"c_schemeid", (CharSequence)propName)) {
                    newScheme.set(propName, (Object)depositScheme.getLong("id"));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"c_depositscheme", (CharSequence)propName)) {
                    newScheme.set(propName, (Object)depositScheme);
                    continue;
                }
                if (StringUtils.equals((CharSequence)"c_depositscheme_id", (CharSequence)propName)) {
                    newScheme.set(propName, (Object)depositScheme.getLong("id"));
                    continue;
                }
                newScheme.set(propName, depositScheme.get(propName.replace("c_", "")));
            }
        }
        this.getModel().setDataChanged(false);
        this.getView().updateView("s_entry");
    }

    private void setInterestTypeParameter() {
        String interestType = (String)this.getModel().getValue("interesttype");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)InterestTypeEnum.FLOAT.getValue().equals(interestType), (String[])new String[]{"referencerate"});
    }

    private void interestTypeChgEvt() {
        String interestType = (String)this.getModel().getValue("interesttype");
        if (InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            this.getModel().setValue("interestrate", null);
        } else if (InterestTypeEnum.FIXED.getValue().equals(interestType)) {
            this.getModel().setValue("referencerate", null);
            this.getModel().setValue("ratefloatpoint", null);
        }
    }

    private void setDepositParameter() {
        DynamicObject deposit = (DynamicObject)this.getModel().getValue("deposit");
        if (EmptyUtil.isEmpty((DynamicObject)deposit)) {
            return;
        }
        String applyType = (String)this.getModel().getValue("applytype");
        if (!DepositApplyTypeEnum.DEPOSIT.getValue().equals(applyType)) {
            this.getModel().setValue("org", ((DynamicObject)deposit.get("org")).getPkValue());
            this.getModel().setValue("investvarieties", ((DynamicObject)deposit.get("investvarieties")).getPkValue());
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"finorginfo", (Object)((DynamicObject)deposit.get("finorginfo")).getPkValue());
            this.getModel().setValue("currency", ((DynamicObject)deposit.get("currency")).getPkValue());
            this.getModel().setValue("amount", deposit.get("amount"));
            this.getModel().setValue("tradechannel", deposit.get("tradechannel"));
            String tradeChannel = (String)this.getModel().getValue("tradechannel");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intdate", (Object)deposit.get("intdate"));
            boolean isOnline = kd.tmc.cim.common.util.StringUtils.equals((CharSequence)tradeChannel, (CharSequence)TradeChannelEnum.ONLINE.getValue());
            DynamicObject investVarieties = (DynamicObject)this.getModel().getValue("investvarieties");
            String investType = investVarieties.getString("investtype");
            if (InvestTypeEnum.isNotice((String)investType)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"term", "expiredate", "deadline"});
                this.getModel().setValue("deadline", null);
                this.getModel().setValue("prenoticeday", (Object)deposit.getString("prenoticeday"));
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"expiredate"});
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)deposit.get("expiredate"));
                if (isOnline) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"deadline", (Object)deposit.get("deadline"));
                } else {
                    this.getModel().setValue("term", deposit.get("term"));
                    this.getModel().setValue("deadline", null);
                }
                if (DepositApplyTypeEnum.RELEASE.getValue().equals(applyType)) {
                    Date expireDate = deposit.getDate("expiredate");
                    Date applyDate = (Date)this.getModel().getValue("applydate");
                    applyDate = EmptyUtil.isNoEmpty((Object)applyDate) ? applyDate : expireDate;
                    this.getModel().setValue("estimatedate", (Object)(expireDate.compareTo(applyDate) >= 0 ? expireDate : applyDate));
                    this.getModel().setValue("releaseamount", (Object)deposit.getBigDecimal("surplusamount"));
                }
            }
            String interestType = deposit.getString("interesttype");
            this.getModel().setValue("interesttype", (Object)interestType);
            this.getModel().setValue("interestrate", deposit.get("interestrate"));
            this.getModel().setValue("referencerate", deposit.get("referencerate"));
            this.getModel().setValue("ratesign", deposit.get("ratesign"));
            this.getModel().setValue("ratefloatpoint", deposit.get("ratefloatpoint"));
            this.getModel().setValue("profitamount", deposit.get("planamount"));
            if (InterestTypeEnum.isRange((String)interestType)) {
                this.getModel().setValue("rangemin", (Object)deposit.getBigDecimal("rangemin"));
                this.getModel().setValue("rangesign", (Object)deposit.getString("rangesign"));
                this.getModel().setValue("rangemax", (Object)deposit.getBigDecimal("rangemax"));
            }
            if (DepositApplyTypeEnum.RELEASE.getValue().equals(applyType)) {
                this.getModel().setValue("finaccountf7", deposit.getDynamicObject("settleaccount").getPkValue());
            }
        }
    }

    private void cleanPropValues() {
        this.getModel().setValue("tradechannel", (Object)TradeChannelEnum.OFFLINE.getValue());
        this.getModel().setValue("deposit", null);
        this.getModel().setValue("org", null);
        this.getModel().setValue("investvarieties", null);
        this.getModel().setValue("finorginfo", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("amount", null);
        this.getModel().setValue("intdate", (Object)DateUtils.truncateDate((Date)new Date()));
        this.getModel().setValue("term", null);
        this.getModel().setValue("expiredate", null);
        this.getModel().setValue("interesttype", (Object)InterestTypeEnum.FIXED.getValue());
        this.getModel().setValue("interestrate", null);
        this.getModel().setValue("referencerate", null);
        this.getModel().setValue("ratesign", (Object)RateSignEnum.ADD.getValue());
        this.getModel().setValue("ratefloatpoint", null);
        this.getModel().setValue("releasetype", null);
        this.getModel().setValue("releaseamount", null);
        this.getModel().setValue("estimatedate", null);
        this.getModel().setValue("deadline", (Object)DepositTermEnum.SIXMONTH.getValue());
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"org", "investvarieties", "finorginfo", "deadline", "currency", "amount", "intdate", "term", "expiredate", "tradechannel", "interesttype", "interestrate", "referencerate", "ratesign", "ratefloatpoint"});
    }

    private void setReleaseType(boolean isPropertyChanged) {
        String applyType = (String)this.getModel().getValue("applytype");
        if (DepositApplyTypeEnum.RELEASE.getValue().equals(applyType)) {
            String investType = Optional.ofNullable((DynamicObject)this.getModel().getValue("investvarieties")).map(r -> r.getString("investtype")).orElse("");
            if (InvestTypeEnum.isNotice((String)investType)) {
                this.setReleaseTypeComboItem(true);
            } else if (InvestTypeEnum.isFixed((String)investType)) {
                this.setReleaseTypeComboItem(false);
            }
            if (isPropertyChanged) {
                this.setReleaseDefaultValue(investType);
            }
        }
    }

    private void setReleaseDefaultValue(String investType) {
        DynamicObject depositBill = (DynamicObject)this.getModel().getValue("deposit");
        this.getModel().setValue("releaseamount", (Object)(EmptyUtil.isEmpty((DynamicObject)depositBill) ? Integer.valueOf(0) : depositBill.getBigDecimal("surplusamount")));
        if (InvestTypeEnum.isNotice((String)investType)) {
            this.getModel().setValue("estimatedate", (Object)DateUtils.truncateDate((Date)new Date()));
            this.getModel().setValue("releasetype", (Object)ReleaseTypeEnum.agreeon.getValue());
        } else if (InvestTypeEnum.isFixed((String)investType)) {
            this.getModel().setValue("releasetype", (Object)ReleaseTypeEnum.expire.getValue());
        }
    }

    private void setReleaseTypeComboItem(boolean isNotice) {
        ArrayList<ComboItem> releaseTypeList = new ArrayList<ComboItem>(2);
        ComboItem comboItem1 = new ComboItem();
        comboItem1.setCaption(new LocaleString(isNotice ? ReleaseTypeEnum.agreeon.getName() : ReleaseTypeEnum.inadvance.getName()));
        comboItem1.setValue(isNotice ? ReleaseTypeEnum.agreeon.getValue() : ReleaseTypeEnum.inadvance.getValue());
        releaseTypeList.add(comboItem1);
        ComboItem comboItem2 = new ComboItem();
        comboItem2.setCaption(new LocaleString(isNotice ? ReleaseTypeEnum.temporary.getName() : ReleaseTypeEnum.expire.getName()));
        comboItem2.setValue(isNotice ? ReleaseTypeEnum.temporary.getValue() : ReleaseTypeEnum.expire.getValue());
        releaseTypeList.add(comboItem2);
        ComboEdit releaseControl = (ComboEdit)this.getControl("releasetype");
        releaseControl.setComboItems(releaseTypeList);
    }

    private void setExpireReDepositComboItem() {
        ArrayList<ComboItem> expireReDepositList = new ArrayList<ComboItem>(3);
        String applyType = (String)this.getModel().getValue("applytype");
        boolean isSubsist = DepositApplyTypeEnum.SUBSIST.getValue().equals(applyType);
        if (!isSubsist) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(ExpireRedepositTypeEnum.NOREDEPOSIT.getName()));
            comboItem.setValue(ExpireRedepositTypeEnum.NOREDEPOSIT.getValue());
            expireReDepositList.add(comboItem);
        }
        ComboItem comboItem1 = new ComboItem();
        comboItem1.setCaption(new LocaleString(ExpireRedepositTypeEnum.HANDPRINCIPAL.getName()));
        comboItem1.setValue(ExpireRedepositTypeEnum.PRINCIPALREDEPOSIT.getValue());
        expireReDepositList.add(comboItem1);
        ComboItem comboItem2 = new ComboItem();
        comboItem2.setCaption(new LocaleString(ExpireRedepositTypeEnum.HANDPRINCIPALINT.getName()));
        comboItem2.setValue(ExpireRedepositTypeEnum.PRINCIPALINTREDEPOSIT.getValue());
        expireReDepositList.add(comboItem2);
        ComboEdit reDepositControl = (ComboEdit)this.getControl("expireredeposit");
        reDepositControl.setComboItems(expireReDepositList);
    }

    private void setExpireReDepositDefValue() {
        String applyType = (String)this.getModel().getValue("applytype");
        boolean isSubsist = DepositApplyTypeEnum.SUBSIST.getValue().equals(applyType);
        if (isSubsist) {
            this.getModel().setValue("expireredeposit", (Object)ExpireRedepositTypeEnum.PRINCIPALREDEPOSIT.getValue());
        } else {
            this.getModel().setValue("expireredeposit", (Object)ExpireRedepositTypeEnum.NOREDEPOSIT.getValue());
        }
    }

    private void setMustInputByApplyType() {
        String applyType = (String)this.getModel().getValue("applytype");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!DepositApplyTypeEnum.DEPOSIT.getValue().equals(applyType) ? 1 : 0) != 0, (String[])new String[]{"deposit"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)DepositApplyTypeEnum.RELEASE.getValue().equals(applyType), (String[])new String[]{"releasetype", "finaccountf7"});
    }

    private void setReleaseDefaultValues() {
        String applyType = (String)this.getModel().getValue("applytype");
        if (!DepositApplyTypeEnum.RELEASE.getValue().equals(applyType)) {
            this.getModel().setValue("releasetype", null);
            this.getModel().setValue("estimatedate", null);
            this.getModel().setValue("releaseamount", null);
        } else {
            this.getModel().setValue("estimatedate", (Object)DateUtils.truncateDate((Date)new Date()));
            DynamicObject depositBill = (DynamicObject)this.getModel().getValue("deposit");
            this.getModel().setValue("releaseamount", (Object)(EmptyUtil.isEmpty((DynamicObject)depositBill) ? Integer.valueOf(0) : depositBill.getBigDecimal("surplusamount")));
        }
    }

    private void setDefaultValues() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("applyorg");
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            this.getModel().setValue("org", (Object)org);
            this.getModel().setValue("currency", (Object)SystemStatusCtrolHelper.getStandardCurrency((long)org.getLong("id")));
        }
    }

    private void setEnableValueByDepositF7() {
        DynamicObject depositBill = (DynamicObject)this.getModel().getValue("deposit");
        if (EmptyUtil.isNoEmpty((DynamicObject)depositBill)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"org", "investvarieties", "finorginfo", "currency", "amount", "intdate", "term", "expiredate", "interesttype", "referencerate", "ratesign", "ratefloatpoint", "tradechannel", "deadline", "rangemin", "rangemax"});
            String intType = (String)this.getModel().getValue("interesttype");
            this.getView().setEnable(Boolean.valueOf(InterestTypeEnum.isRange((String)intType)), new String[]{"interestrate"});
        }
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        switch (key) {
            case "term": {
                if (TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) break;
                e.setCancel(true);
                this.getView().updateView(key);
                return;
            }
            case "releasetype": {
                DynamicObject depositBill = (DynamicObject)this.getModel().getValue("deposit");
                if (!EmptyUtil.isEmpty((DynamicObject)depositBill)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5b58\u6b3e\u5355\u3002", (String)"DepositApplyEdit_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
                return;
            }
            case "expiredate": {
                if (!EmptyUtil.isNoEmpty((Object)value)) break;
                this.validateExpireDate(e, value, key);
            }
        }
    }

    private void calTermOrIntDate(String tradeChannel) {
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        if (!kd.tmc.cim.common.util.StringUtils.equals((CharSequence)TradeChannelEnum.ONLINE.getValue(), (CharSequence)tradeChannel)) {
            Date intDate = (Date)this.getModel().getValue("intdate");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, expireDate})) {
                return;
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)TermHelper.callTermLargeEqualZore((Date)intDate, (Date)expireDate));
        } else {
            String deadLine = (String)this.getModel().getValue("deadline");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{deadLine, expireDate})) {
                return;
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intdate", (Object)DepositHelper.calStartDate((Date)expireDate, (String)deadLine));
        }
    }

    private void calExpireDate(String tradeChannel) {
        Date expireDate;
        Date intDate = (Date)this.getModel().getValue("intdate");
        if (!kd.tmc.cim.common.util.StringUtils.equals((CharSequence)TradeChannelEnum.ONLINE.getValue(), (CharSequence)tradeChannel)) {
            String term = (String)this.getModel().getValue("term");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, term})) {
                return;
            }
            expireDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)intDate);
        } else {
            String deadLine = (String)this.getModel().getValue("deadline");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, deadLine})) {
                return;
            }
            expireDate = DepositHelper.calEndDate((Date)intDate, (String)deadLine);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)expireDate);
    }

    private void setDepositFilter(BeforeF7SelectEvent e) {
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdCollection = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("org.id", "in", (Object)orgIdCollection);
        String applyType = (String)this.getModel().getValue("applytype");
        if (DepositApplyTypeEnum.SUBSIST.getValue().equals(applyType)) {
            QFilter investQFilter = new QFilter("investvarieties.investtype", "in", (Object)InvestTypeEnum.getFixedGroup());
            qFilter.and(investQFilter);
            this.addDepositF7Filter(qFilter);
        }
        listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private void setOrgFilter(BeforeF7SelectEvent e) {
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdCollection = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("id", "in", (Object)orgIdCollection.toArray());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    private void setReferenceRateFilter(BeforeF7SelectEvent e) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            QFilter qFilter = new QFilter("currency", "=", currency.getPkValue());
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private void tradeChannelChgEvt(boolean isInit) {
        boolean isAddNew;
        String tradeChannel = (String)this.getModel().getValue("tradechannel");
        boolean isOnline = kd.tmc.cim.common.util.StringUtils.equals((CharSequence)tradeChannel, (CharSequence)TradeChannelEnum.ONLINE.getValue());
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus opStatus = billShowParameter.getStatus();
        boolean bl = isAddNew = opStatus == OperationStatus.ADDNEW;
        if ((isAddNew || !isInit) && isOnline) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", null);
            this.getModel().setValue("deadline", (Object)DepositTermEnum.SIXMONTH.getValue());
            this.getModel().setValue("interesttype", (Object)InterestTypeEnum.FIXED.getValue());
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"intdate", "expiredate"});
        String investType = Optional.ofNullable((DynamicObject)this.getModel().getValue("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (isOnline && InvestTypeEnum.isFixed((String)investType) ? 1 : 0) != 0, (String[])new String[]{"deadline"});
    }

    private void validateExpireDate(BeforeFieldPostBackEvent e, Object value, String fieldName) {
        if (kd.tmc.cim.common.util.StringUtils.equals((CharSequence)TradeChannelEnum.ONLINE.getValue(), (CharSequence)((String)this.getModel().getValue("tradechannel")))) {
            return;
        }
        Date expireDate = DateUtils.stringToDate((String)value.toString(), (String)"yyyy-MM-dd");
        Date intDate = (Date)this.getModel().getValue("intdate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, expireDate})) {
            return;
        }
        if (expireDate.compareTo(intDate) <= 0) {
            e.setCancel(true);
            String tips = DepositApplyTypeEnum.isAgree((String)((String)this.getModel().getValue("applytype"))) ? ResManager.loadKDString((String)"\u534f\u8bae\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u534f\u8bae\u5f00\u59cb\u65e5\u671f\u3002", (String)"DepositDealEdit_6", (String)"tmc-cim-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5b58\u6b3e\u8d77\u606f\u65e5\u3002", (String)"DepositDealEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            this.getView().updateView(fieldName);
        }
    }

    private void investVarietiesChgEvt() {
        boolean flag;
        IDataModel model = this.getModel();
        DynamicObject investVarieties = (DynamicObject)model.getValue("investvarieties");
        boolean bl = flag = EmptyUtil.isNoEmpty((DynamicObject)investVarieties) && investVarieties.getBoolean("isproduct");
        if (flag) {
            String number = investVarieties.getString("number");
            DynamicObject product = TmcDataServiceHelper.loadSingleFromCache((String)"ifm_ldproduct", (String)"center,currency,ratetype,productprice,referrate,ratesignbp,ratefloatpoints", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            boolean enable = true;
            if (EmptyUtil.isNoEmpty((DynamicObject)product)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"finorginfo", (Object)product.getDynamicObject("center"));
                model.setValue("currency", (Object)product.getDynamicObject("currency"));
                model.setValue("interesttype", (Object)product.getString("ratetype"));
                model.setValue("interestrate", (Object)product.getBigDecimal("productprice"));
                model.setValue("referencerate", (Object)product.getDynamicObject("referrate"));
                model.setValue("ratesign", (Object)product.getString("ratesignbp"));
                model.setValue("ratefloatpoint", (Object)product.getBigDecimal("ratefloatpoints"));
                enable = false;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradechannel", (Object)"offline");
            }
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{"tradechannel"});
        }
        this.getView().setEnable(Boolean.valueOf(!flag), new String[]{"finorginfo", "currency", "interesttype", "referencerate"});
    }

    private void setViewRule() {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"expireredeposit"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"prenoticeday"});
    }

    private void finOrgInfoChgEvt() {
        boolean settleCenterBill = DepositHelper.isSettleCenterBill((DynamicObject)this.getModel().getDataEntity());
        if (settleCenterBill) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"investvarieties", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradechannel", (Object)"offline");
        }
        this.getView().setEnable(Boolean.valueOf(!settleCenterBill), new String[]{"tradechannel"});
    }

    private void isRollingChgEvt() {
        boolean isRolling = (Boolean)this.getModel().getValue("isrolling");
        DynamicObject depositF7 = (DynamicObject)this.getModel().getValue("deposit");
        if (EmptyUtil.isNoEmpty((DynamicObject)depositF7)) {
            if (isRolling) {
                BigDecimal planAmount;
                DynamicObject depositBill = TmcDataServiceHelper.loadSingle((Object)depositF7.getPkValue(), (String)"cim_deposit", (String)"expireredeposit,surplusamount,planamount");
                if (ExpireRedepositTypeEnum.PRINCIPALINTREDEPOSIT.getValue().equals(depositBill.getString("expireredeposit")) && EmptyUtil.isNoEmpty((BigDecimal)(planAmount = depositBill.getBigDecimal("planamount")))) {
                    BigDecimal amount = depositBill.getBigDecimal("surplusamount").add(planAmount);
                    this.getModel().setValue("amount", (Object)amount);
                }
            } else {
                this.getModel().setValue("amount", (Object)depositF7.getBigDecimal("surplusamount"));
            }
        }
    }

    private void setLastAmountColumnVisible() {
        DynamicObject finorg;
        DynamicObject finorgtype;
        boolean isShowLastAmt = false;
        String applyType = (String)this.getModel().getValue("applytype");
        String status = (String)this.getModel().getValue("billstatus");
        if (kd.tmc.cim.common.util.StringUtils.equals((CharSequence)DepositApplyTypeEnum.DEPOSIT.getValue(), (CharSequence)applyType) && kd.tmc.cim.common.util.StringUtils.equals((CharSequence)BillStatusEnum.AUDIT.getValue(), (CharSequence)status) && EmptyUtil.isNoEmpty((DynamicObject)(finorgtype = (DynamicObject)Optional.ofNullable((DynamicObject)this.getModel().getValue("finorginfo")).map(r -> r.getDynamicObject("finorgtype")).orElse(null))) && EmptyUtil.isNoEmpty((DynamicObject)(finorg = QueryServiceHelper.queryOne((String)"bd_finorgtype", (String)"type", (QFilter[])new QFilter[]{new QFilter("id", "=", finorgtype.getPkValue())}))) && !kd.tmc.cim.common.util.StringUtils.equals((CharSequence)FinOrgTypeEnum.CLEARINGHOUSE.getValue(), (CharSequence)finorg.getString("type"))) {
            isShowLastAmt = true;
        }
        if (isShowLastAmt) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"lastamount"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"lastamount"});
        }
    }

    private void setInvestVarietiesFilter(BeforeF7SelectEvent e) {
        DynamicObject finOrg = (DynamicObject)this.getModel().getValue("finorginfo");
        if (EmptyUtil.isEmpty((DynamicObject)finOrg)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b58\u6b3e\u673a\u6784\u201d\u3002", (String)"DepositApplyEdit_6", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        ListShowParameter f7showparam = (ListShowParameter)e.getFormShowParameter();
        List qFilters = f7showparam.getListFilterParameter().getQFilters();
        boolean settleCenterBill = DepositHelper.isSettleCenterBill((DynamicObject)this.getModel().getDataEntity());
        if (settleCenterBill) {
            f7showparam.setCaption(ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u5b58\u6b3e\u4ea7\u54c1", (String)"DepositApplyEdit_7", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            Map productMap = TmcDataServiceHelper.loadFromCache((String)"ifm_ldproduct", (String)"number", (QFilter[])new QFilter[]{new QFilter("center", "=", finOrg.getPkValue())});
            if (EmptyUtil.isEmpty((Object)productMap) || productMap.size() == 0) {
                qFilters.add(new QFilter("id", "=", (Object)0L));
            }
            List numberList = productMap.values().stream().map(r -> r.getString("number")).collect(Collectors.toList());
            List investIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_investvarieties", (QFilter[])new QFilter[]{new QFilter("number", "in", numberList)}, null, (int)-1);
            qFilters.add(new QFilter("id", "in", (Object)investIds));
        } else {
            qFilters.add(new QFilter("investsource", "!=", (Object)"settlecenter"));
        }
    }

    private void setReleaseTypeForReleaseApply() {
        String applyType = (String)this.getModel().getValue("applytype");
        String investType = Optional.ofNullable((DynamicObject)this.getModel().getValue("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        if (kd.tmc.cim.common.util.StringUtils.equals((CharSequence)DepositApplyTypeEnum.RELEASE.getValue(), (CharSequence)applyType)) {
            if (InvestTypeEnum.isFixed((String)investType)) {
                this.setReleaseType();
            } else {
                this.setAccountDay();
            }
        }
    }

    private void addDepositF7Filter(QFilter qFilter) {
        QFilter baseQfilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        baseQfilter.and("applytype", "=", (Object)DepositApplyTypeEnum.SUBSIST.getValue());
        DynamicObjectCollection applyDoing = QueryServiceHelper.query((String)"cim_deposit_apply", (String)"id,deposit", (QFilter[])new QFilter[]{baseQfilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)applyDoing)) {
            List useingDepositIds = applyDoing.stream().filter(r -> r.getLong("id") != ((Long)this.getModel().getValue("id")).longValue()).map(r -> r.getLong("deposit")).collect(Collectors.toList());
            qFilter.and(new QFilter("id", "not in", useingDepositIds));
        }
        QFilter finOrgFilter = new QFilter("finorgtype.type", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        finOrgFilter.and("enable", "=", (Object)"1");
        List finOrgTypeIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_finorginfo", (QFilter[])finOrgFilter.toArray(), (String)"", (int)-1);
        qFilter.and(new QFilter("finorginfo", "not in", (Object)finOrgTypeIds));
    }

    private void setDefaultValue() {
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        Object depositId = paraMap.get("depositId");
        if (EmptyUtil.isNoEmpty(depositId)) {
            this.getModel().setValue("applytype", (Object)DepositApplyTypeEnum.RELEASE.getValue());
            this.getModel().setValue("deposit", depositId);
            this.setValueByDeposit();
            TmcViewInputHelper.registerDisableStatus((IFormView)this.getView(), (String[])new String[]{"applytype", "deposit"});
            String tradeChannel = (String)this.getModel().getValue("tradechannel");
            if (TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
                TmcViewInputHelper.registerDisableStatus((IFormView)this.getView(), (String[])new String[]{"releasetype"});
            }
            DynamicObject depositBill = (DynamicObject)this.getModel().getValue("deposit");
            this.getModel().setValue("prenoticeday", (Object)depositBill.getString("prenoticeday"));
            this.setProfitAmount();
        }
    }

    private void setReleaseType() {
        Date estimateDate = (Date)this.getModel().getValue("estimatedate");
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{estimateDate, expireDate})) {
            return;
        }
        if (estimateDate.compareTo(expireDate) >= 0) {
            this.getModel().setValue("releasetype", (Object)ReleaseTypeEnum.expire.getValue());
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"expireredeposit"});
        } else {
            this.getModel().setValue("releasetype", (Object)ReleaseTypeEnum.inadvance.getValue());
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"expireredeposit"});
        }
    }

    private void setAccountDay() {
        Date estimateDate;
        String preNoticeDay = (String)this.getModel().getValue("prenoticeday");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{preNoticeDay, estimateDate = (Date)this.getModel().getValue("estimatedate")}) || PreNoticeDayEnum.isOther((String)preNoticeDay)) {
            return;
        }
        this.getModel().setValue("accountdate", (Object)DateUtils.getNextDay((Date)estimateDate, (int)PreNoticeDayEnum.getDays((String)preNoticeDay)));
    }

    private void setMustInputSpecialScene() {
        String releaseType = (String)this.getModel().getValue("releasetype");
        String applyType = (String)this.getModel().getValue("applytype");
        String tradeChannel = (String)this.getModel().getValue("tradechannel");
        boolean isMustInput = DepositApplyTypeEnum.RELEASE.getValue().equals(applyType) && TradeChannelEnum.ONLINE.getValue().equals(tradeChannel) && ReleaseTypeEnum.isAgreeon((String)releaseType);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isMustInput, (String[])new String[]{"profitamount", "releaseamount", "estimatedate", "accountdate"});
        this.getView().setEnable(Boolean.valueOf(!isMustInput), new String[]{"releasetype"});
        boolean isTransfer = DepositApplyTypeEnum.RELEASE.getValue().equals(applyType) && (Boolean)this.getModel().getValue("accepttransfer") != false;
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isTransfer, (String[])new String[]{"estimatedate"});
    }

    private void setDefaultRate() {
        BigDecimal rangeMin = (BigDecimal)this.getModel().getValue("rangemin");
        BigDecimal rangeMax = (BigDecimal)this.getModel().getValue("rangemax");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{rangeMin, rangeMax})) {
            return;
        }
        BigDecimal halfValue = rangeMin.add(rangeMax).divide(new BigDecimal("2"));
        this.getModel().setValue("interestrate", (Object)halfValue);
    }

    private void setInterestTypeEnum() {
        boolean inquiry = (Boolean)this.getModel().getValue("inquiry");
        if (!inquiry) {
            DepositHelper.initInterestTypeEnum((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"investvarieties", (String)"interesttype");
        }
    }

    private void setProfitAmount() {
        if (!DepositApplyTypeEnum.RELEASE.getValue().equals(this.getModel().getValue("applytype"))) {
            return;
        }
        DynamicObject deposit = (DynamicObject)this.getModel().getValue("deposit");
        BigDecimal releaseAmt = (BigDecimal)this.getModel().getValue("releaseamount");
        Date redeemDate = (Date)this.getModel().getValue("estimatedate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{deposit, releaseAmt, redeemDate})) {
            return;
        }
        boolean isAcceptTransfer = (Boolean)this.getModel().getValue("accepttransfer");
        IntBillInfo intBillInfo = DepositHelper.calcDepositBillInt((DynamicObject)this.getModel().getDataEntity(), (boolean)isAcceptTransfer);
        if (EmptyUtil.isNoEmpty((Object)intBillInfo)) {
            this.getModel().setValue("profitamount", (Object)intBillInfo.getAmount());
        }
    }
}

