/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.formplugin.intbatch.AbstractIntPreEdit;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositIntPreEdit
extends AbstractIntPreEdit {
    @Override
    protected String chooseFinBillFormId() {
        return "cim_deposit";
    }

    @Override
    protected void calIntAndFillIntEntry() {
        Date intEndDate = (Date)this.getModel().getValue("prestenddate");
        DynamicObject finBill = TmcDataServiceHelper.loadSingleFromCache((Object)this.getModel().getValue("sourcebillid"), (String)this.chooseFinBillFormId());
        if (EmptyUtil.isEmpty((DynamicObject)finBill)) {
            return;
        }
        Date tmpDate = Optional.ofNullable(finBill.getDate("endpreinstdate")).orElseGet(() -> DateUtils.getNextDay((Date)finBill.getDate("intdate"), (int)-1));
        Date intStartDate = DateUtils.getNextDay((Date)tmpDate, (int)1);
        IntBillInfo intBillInfo = DepositHelper.calcDepositBillInt((DynamicObject)finBill, (Date)intStartDate, (Date)intEndDate);
        this.getModel().setValue("predictpreinstamt", (Object)intBillInfo.getAmount());
        this.getModel().setValue("actpreinstamt", (Object)intBillInfo.getAmount());
        List<Map<String, Object>> intDetail = this.buildEntryData(intBillInfo);
        TmcViewInputHelper.batchFillEntity((String)"entrys", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), intDetail);
    }

    private List<Map<String, Object>> buildEntryData(IntBillInfo intBillInfo) {
        List details = intBillInfo.getDetails();
        if (EmptyUtil.isEmpty((Collection)details)) {
            return null;
        }
        ArrayList<Map<String, Object>> intDetails = new ArrayList<Map<String, Object>>(details.size());
        for (IntBillDetailInfo intDetail : details) {
            HashMap<String, Comparable<Date>> map = new HashMap<String, Comparable<Date>>();
            map.put("inststartdate", intDetail.getBeginDate());
            map.put("instenddate", intDetail.getEndDate());
            map.put("instdays", Integer.valueOf(intDetail.getDays()));
            map.put("instprincipalamt", intDetail.getPrinciple());
            map.put("rate", intDetail.getRate());
            map.put("ratetrandays", Integer.valueOf(intDetail.getBasisDay()));
            map.put("instamt", intDetail.getAmount());
            intDetails.add(map);
        }
        return intDetails;
    }
}

