/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.helper.IntBillBatchHelper;
import kd.tmc.cim.formplugin.intbatch.AbstractNavigateAddPlugin;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositNavigateAddPlugin
extends AbstractNavigateAddPlugin {
    @Override
    protected String chooseOpenFinBillId() {
        return "cim_deposit";
    }

    @Override
    protected QFilter setOpenFinBillFilter() {
        List<String> finStatus = Arrays.asList(FinServiceStatusEnum.subscribe_done.getValue(), FinServiceStatusEnum.subscribe_part.getValue());
        QFilter qFilter = new QFilter("bizstatus", "in", finStatus);
        qFilter.and(new QFilter("isresubmit", "!=", (Object)Boolean.TRUE));
        QFilter offChannelFilter = new QFilter("tradechannel", "!=", (Object)TradeChannelEnum.ONLINE.getValue());
        QFilter tradeChannleFilter = offChannelFilter.or(new QFilter("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue()).and(new QFilter("bebankstatus", "=", (Object)BebankStatusEnum.TS.getValue())));
        qFilter.and(tradeChannleFilter);
        DynamicObjectCollection company = (DynamicObjectCollection)this.getModel().getValue("company");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)company)) {
            Set companyIds = company.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
            qFilter.and("org", "in", companyIds);
        } else {
            String appId = this.getView().getFormShowParameter().getAppId();
            Long userId = RequestContext.get().getCurrUserId();
            List companyIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"cim_depositprebatch", (String)"47150e89000000ac");
            qFilter.and("org", "in", (Object)companyIds);
        }
        DynamicObjectCollection currency = (DynamicObjectCollection)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currency)) {
            Set ids = currency.stream().map(c -> c.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            qFilter.and("currency", "in", ids);
        }
        Date endintdate = (Date)this.getModel().getValue("endintdate");
        qFilter.and(QFilter.isNotNull((String)"endpreinstdate").and("endpreinstdate", "<", (Object)DateUtils.getLastDay((Date)endintdate, (int)1)).or(QFilter.isNull((String)"endpreinstdate").and("intdate", "<=", (Object)DateUtils.getLastDay((Date)endintdate, (int)1))));
        Object loanIds = this.getView().getFormShowParameter().getCustomParams().get("loanIds");
        if (EmptyUtil.isNoEmpty(loanIds)) {
            qFilter.and("id", "not in", loanIds);
        }
        return qFilter;
    }

    @Override
    protected String chooseBatchPreFormId() {
        return "cim_depositprebatch";
    }

    @Override
    protected Date getStartIntDate(DynamicObject finBill) {
        if (IntBillBatchHelper.isAutoWriteRed((DynamicObject)finBill)) {
            if (finBill.getBoolean("accepttransfer") && EmptyUtil.isNoEmpty((Object)finBill.getDate("transferdate"))) {
                return DepositHelper.getIntCalcStartDateForHugePre((DynamicObject)finBill);
            }
            return DepositHelper.getIntCalcStartDate((DynamicObject)finBill);
        }
        Date lastPayinstDate = finBill.getDate("endpreinstdate");
        if (EmptyUtil.isNoEmpty((Object)lastPayinstDate)) {
            return DateUtils.getNextDay((Date)lastPayinstDate, (int)1);
        }
        return finBill.getDate("intdate");
    }

    @Override
    protected String getFunction() {
        return "preint";
    }
}

