/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.cim.formplugin.deposit.AbstractDepositList;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;

public class FixedDepositList
extends AbstractDepositList {
    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter initQfilter = new QFilter("isinit", "=", (Object)Boolean.TRUE).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter unionFilter = initQfilter.or(new QFilter("isinit", "=", (Object)Boolean.FALSE));
        e.getQFilters().add(unionFilter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int i, int i1) {
                DynamicObjectCollection rows = super.getData(i, i1);
                if (rows.isEmpty()) {
                    return rows;
                }
                DataEntityPropertyCollection properties = rows.getDynamicObjectType().getProperties();
                if (!properties.containsKey((Object)"planamount") || !properties.containsKey((Object)"totalamount")) {
                    return rows;
                }
                DecimalProp addProp = new DecimalProp();
                addProp.setName("allamount");
                addProp.setDisplayName(new LocaleString("allamount"));
                properties.add((Object)addProp);
                for (DynamicObject row : rows) {
                    BigDecimal planAmt = row.getBigDecimal("planamount");
                    BigDecimal revenueAmt = row.getBigDecimal("totalamount");
                    row.set("allamount", (Object)planAmt.add(revenueAmt));
                }
                return rows;
            }
        });
    }

    @Override
    public String[] chooseInvestType() {
        return InvestTypeEnum.getFixedGroup();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String dataInclude = (String)e.getFormShowParameter().getCustomParam("dataInclude");
        if (StringUtils.equals((CharSequence)"fixedAndNotice", (CharSequence)dataInclude)) {
            e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u5b58\u6b3e\u5904\u7406", (String)"FixedDepositList_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        }
    }
}

