/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.deposit;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.ReleaseTypeEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.formplugin.deposit.AbstractReleaseList;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class NoticeReleaseList
extends AbstractReleaseList {
    @Override
    public String chooseDepositFormId() {
        return "cim_noticedeposit";
    }

    @Override
    public String[] chooseInvestType() {
        return new String[]{InvestTypeEnum.notice.getValue()};
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "commitbe": {
                this.validateCommitBe(args);
                break;
            }
        }
    }

    private void validateCommitBe(BeforeDoOperationEventArgs args) {
        Long selectedId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)selectedId)) {
            return;
        }
        DynamicObjectCollection releaseCol = QueryServiceHelper.query((String)"cim_noticerelease", (String)"id,billstatus,tradechannel,releasetype,isautodraw,accountdate,redeemdate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectedId)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)releaseCol)) {
            return;
        }
        DynamicObject release = (DynamicObject)releaseCol.get(0);
        if (!BillStatusEnum.isAudit((String)release.getString("billstatus")) || !TradeChannelEnum.ONLINE.getValue().equals(release.getString("tradechannel"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5ba1\u6838\u4e14\u4ea4\u6613\u6e20\u9053\u662f\u94f6\u4f01\u76f4\u8054\u7684\u5355\u636e\u3002", (String)"NoticeReleaseList_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String releaseType = release.getString("releasetype");
        if (!(ReleaseTypeEnum.isTemporary((String)releaseType) || ReleaseTypeEnum.isAgreeon((String)releaseType) && !release.getBoolean("isautodraw"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89e3\u6d3b\u7c7b\u578b\u4e3a\u975e\u7ea6\u5b9a\u89e3\u6d3b\u6216\u8005\u89e3\u6d3b\u7c7b\u578b\u4e3a\u7ea6\u5b9a\u89e3\u6d3b&\u81ea\u52a8\u652f\u53d6\u4e3a\u5426\u7684\u5355\u636e\u3002", (String)"NoticeReleaseList_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (ReleaseTypeEnum.isAgreeon((String)releaseType) && !release.getBoolean("isautodraw") && DateUtils.getCurrentDate().compareTo(release.getDate("redeemdate")) < 0 && !this.getPageCache().getAll().containsKey("passCommitBe")) {
            args.setCancel(true);
            this.getPageCache().remove("passCommitBe");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c1a\u672a\u5230\u8fbe\u9884\u7ea6\u652f\u53d6\u65e5\u671f\uff0c\u8bf7\u95ee\u662f\u5426\u7ee7\u7eed?", (String)"NoticeReleaseList_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("commitBeCall", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        if (event.getResult() != MessageBoxResult.Yes) {
            return;
        }
        switch (callBackId = event.getCallBackId()) {
            case "commitBeCall": {
                this.getPageCache().put("passCommitBe", "true");
                this.getView().invokeOperation("commitbe");
                break;
            }
        }
    }
}

