/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.dptrevenue;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenueEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        TextEdit recAcct = (TextEdit)this.getControl("recaccount");
        recAcct.addButtonClickListener((ClickListener)this);
        BasedataEdit recAcctF7 = (BasedataEdit)this.getControl("recaccountf7");
        recAcctF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        String fieldName = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"recaccount")) {
            ((BasedataEdit)this.getControl("recaccountf7")).click();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldName = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (fieldName) {
            case "recaccountf7": {
                this.setRecAccountF7Filter(showParameter);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.setBizDateRange();
        this.getView().setVisible(Boolean.valueOf(this.getDemandRateBoolean()), new String[]{"demandrate"});
        this.setExpireRedepositName();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName;
        switch (fieldName = e.getProperty().getName()) {
            case "bizdate": {
                this.reSetRevenueEntry();
                this.getView().setVisible(Boolean.valueOf(this.getDemandRateBoolean()), new String[]{"demandrate"});
                this.calRealRate();
                break;
            }
            case "actpreinstamt": {
                this.calRealRate();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("recaccount".equals(actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (EmptyUtil.isEmpty((Collection)returnData)) {
                return;
            }
            this.getModel().setValue(actionId, (Object)returnData.get(0).getNumber());
            this.getModel().setValue("recaccountf7", returnData.get(0).getPrimaryKeyValue());
        }
    }

    private void reSetRevenueEntry() {
        Date endDate = (Date)this.getModel().getValue("bizdate");
        Date startDate = (Date)this.getModel().getValue("prestartdate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate})) {
            return;
        }
        DynamicObject depositBill = TmcDataServiceHelper.loadSingleFromCache((String)"cim_deposit", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getModel().getValue("sourcebillid"))});
        IntBillInfo intBillInfo = DepositHelper.calcDepositBillInt((DynamicObject)depositBill, (Date)startDate, (Date)endDate);
        this.resetRevenueEntry(intBillInfo);
    }

    private void resetRevenueEntry(IntBillInfo intBillInfo) {
        if (EmptyUtil.isEmpty((Object)intBillInfo)) {
            return;
        }
        this.getModel().setValue("prestartdate", (Object)intBillInfo.getBeginDate());
        this.getModel().setValue("prestenddate", (Object)intBillInfo.getEndDate());
        this.getModel().setValue("predictpreinstamt", (Object)intBillInfo.getAmount());
        this.getModel().setValue("actpreinstamt", (Object)intBillInfo.getAmount());
        DepositHelper.setRevenueEntry((DynamicObject)this.getModel().getDataEntity(true), (IntBillInfo)intBillInfo);
        this.getView().updateView("entrys");
    }

    private void setRecAccountF7Filter(ListShowParameter showParameter) {
        DynamicObject currency;
        QFilter qFilter = new QFilter("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            QFilter acctFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)org.getLong("id"));
            qFilter.and(acctFilter);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(currency = (DynamicObject)this.getModel().getValue("currency")))) {
            qFilter.and(new QFilter("currency.fbasedataid.id", "=", currency.getPkValue()));
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "recaccount"));
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private DynamicObject getDepositBill() {
        return TmcDataServiceHelper.loadSingleFromCache((String)"cim_deposit", (String)"intdate,lastrevenuedate,investvarieties,expiredate", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getModel().getValue("sourcebillid"))});
    }

    private void setBizDateRange() {
        DateEdit bizDate = (DateEdit)this.getControl("bizdate");
        DynamicObject depositBill = this.getDepositBill();
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return;
        }
        Date minDate = DepositHelper.getIntCalcStartDate((DynamicObject)depositBill);
        bizDate.setMinDate(DateUtils.getNextDay((Date)minDate, (int)1));
    }

    private boolean getDemandRateBoolean() {
        String revenueSort = (String)this.getModel().getValue("revenuesort");
        boolean scene1 = RevenueSortEnum.redeem_revenue.getValue().equals(revenueSort);
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        if (EmptyUtil.isEmpty((Object)bizDate)) {
            return scene1;
        }
        DynamicObject depositBill = this.getDepositBill();
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return scene1;
        }
        String investType = Optional.ofNullable(depositBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        boolean scene2 = RevenueSortEnum.revenue.getValue().equals(revenueSort) && InvestTypeEnum.isFixed((String)investType) && bizDate.compareTo(depositBill.getDate("expiredate")) > 0;
        return scene1 || scene2;
    }

    private void calRealRate() {
        BigDecimal revenueAmt = (BigDecimal)this.getModel().getValue("actpreinstamt");
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entrys");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{revenueAmt, rows})) {
            this.getModel().setValue("realrate", null);
            return;
        }
        this.getModel().setValue("realrate", (Object)DepositHelper.calcRealRate((DynamicObjectCollection)rows, (BigDecimal)revenueAmt));
    }

    private void setExpireRedepositName() {
        ComboEdit expireRedeposit = (ComboEdit)this.getControl("expireredeposit");
        if (EmptyUtil.isEmpty((Object)expireRedeposit)) {
            return;
        }
        String investType = Optional.ofNullable((DynamicObject)this.getModel().getValue("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        if (InvestTypeEnum.isNotice((String)investType)) {
            expireRedeposit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8f6c\u5b58\u65b9\u5f0f", (String)"DptRevenueEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0])));
        }
    }
}

