/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.dptrevenue;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cim.formplugin.finsubscribe.FinSubscribeImportPlugin;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenueImportPlugin
extends AbstractBasePlugIn {
    private static Log logger = LogFactory.getLog(FinSubscribeImportPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "entryimport": {
                this.showImportForm();
                break;
            }
        }
    }

    private void showImportForm() {
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId("cim_entryimport");
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("BillFormId", this.getModel().getDataEntityType().getName());
        params.put("BillEntryId", "revenue_entry");
        showForm.setCustomParams(params);
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cim_entryimport"));
        this.getView().showForm(showForm);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("cim_entryimport".equals(e.getActionId())) {
            Map data = (Map)e.getReturnData();
            if (data == null) {
                return;
            }
            this.entryImportDataHandler(data);
        }
    }

    private void entryImportDataHandler(Map<String, Object> importReturnData) {
        String entryProp = "revenue_entry";
        Object imptMethod = importReturnData.get("imptmethod");
        HashSet<Date> dateSet = new HashSet<Date>(16);
        if ("cover".equals(imptMethod)) {
            this.getModel().deleteEntryData(entryProp);
        } else if ("append".equals(imptMethod)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryProp);
            for (int i = entryentity.size() - 1; i >= 0; --i) {
                DynamicObject entry = (DynamicObject)entryentity.get(i);
                if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{entry.get("revenuedate"), entry.get("revenuecalamount")})) {
                    this.getModel().deleteEntryRow(entryProp, i);
                    this.getView().updateView(entryProp);
                }
                dateSet.add((Date)entry.get("revenuedate"));
            }
        }
        List rowDatas = (List)importReturnData.get("rowDatas");
        StringBuilder errorInfo = new StringBuilder();
        Set billnos = rowDatas.stream().map(o -> (String)o.get("billno")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(billnos) && billnos.size() > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7f16\u7801\u5b57\u6bb5\u5b58\u5728\u591a\u4e2a,\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"DptRevenueImportPlugin_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (EmptyUtil.isNoEmpty(billnos) && billnos.size() == 1 && !billnos.toArray()[0].equals(this.getModel().getValue("billno"))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5b58\u5728\u5bfc\u5165\u7684\u7f16\u7801\u5b57\u6bb5\u4e0e\u5f53\u524d\u5355\u636e\u7f16\u53f7\u4e0d\u4e00\u81f4,\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"DptRevenueImportPlugin_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().beginInit();
        block9: for (Map row : rowDatas) {
            String tips;
            int rowIndex = this.getModel().createNewEntryRow(entryProp);
            try {
                for (Map.Entry r : row.entrySet()) {
                    String tips2;
                    String key = (String)r.getKey();
                    String value = (String)r.getValue();
                    IDataEntityProperty property = this.getModel().getProperty(key);
                    if ("revenuedesc".equals(key)) {
                        TextAreaProp text = new TextAreaProp();
                        if (property instanceof TextAreaProp) {
                            text = (TextAreaProp)property;
                        }
                        if (text.getMaxLenth() > 0 && EmptyUtil.isNoEmpty((String)value) && value.length() > text.getMaxLenth()) {
                            value = value.substring(0, text.getMaxLenth());
                            String maxTip = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s \u5b57\u6bb5\u6570\u636e\u8d85\u51fa\u6700\u5927\u9650\u5236, \u5df2\u622a\u53d6\u6709\u6548\u90e8\u5206\u3002", (String)"DptRevenueImportPlugin_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
                            errorInfo.append(maxTip).append("\n");
                        }
                        this.getModel().setValue(key, (Object)value, rowIndex);
                    }
                    if (property instanceof DecimalProp) {
                        try {
                            BigDecimal amount = new BigDecimal(value);
                            if (amount.compareTo(BigDecimal.ZERO) <= 0) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u989d\u6570\u636e\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"DptRevenueImportPlugin_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                            }
                            if (amount.compareTo(new BigDecimal("999999999.99")) > 0) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u989d\u6570\u503c\u4e0d\u80fd\u5927\u4e8e999999999.99\u3002", (String)"DptRevenueImportPlugin_5", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                            }
                            this.getModel().setValue(key, (Object)amount, rowIndex);
                        }
                        catch (Exception e) {
                            this.getModel().deleteEntryRow(entryProp, rowIndex);
                            tips2 = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s", (String)"DptRevenueImportPlugin_6", (String)"tmc-cim-formplugin", (Object[])new Object[0]), row.get("excelrow"), e.getMessage());
                            errorInfo.append(tips2).append("\n");
                            continue block9;
                        }
                    }
                    if (!"revenuedate".equals(key)) continue;
                    try {
                        if (EmptyUtil.isEmpty((String)value)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DptRevenueImportPlugin_7", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                        }
                        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                        Date date = sf.parse(value);
                        if (!dateSet.add(date)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u65e5\u671f\u4e0d\u5141\u8bb8\u76f8\u7b49\u3002", (String)"DptRevenueImportPlugin_8", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                        }
                        Date intStartDate = (Date)this.getModel().getValue("intdate");
                        if (date.compareTo(intStartDate) < 0) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5b58\u6b3e\u8d77\u606f\u65e5\u3002", (String)"DptRevenueImportPlugin_9", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                        }
                        Date expireDate = (Date)this.getModel().getValue("expiredate");
                        if (EmptyUtil.isNoEmpty((Object)expireDate) && date.compareTo(expireDate) > 0) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5230\u671f\u65e5\u3002", (String)"DptRevenueImportPlugin_10", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                        }
                        this.getModel().setValue(key, (Object)date, rowIndex);
                    }
                    catch (KDBizException bizExp) {
                        this.getModel().deleteEntryRow(entryProp, rowIndex);
                        tips2 = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s", (String)"DptRevenueImportPlugin_6", (String)"tmc-cim-formplugin", (Object[])new Object[0]), row.get("excelrow"), bizExp.getMessage());
                        errorInfo.append(tips2).append("\n");
                        continue block9;
                    }
                    catch (Exception e) {
                        this.getModel().deleteEntryRow(entryProp, rowIndex);
                        String importTip = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s \u5b57\u6bb5, \u8f93\u5165\u6570\u636e\u683c\u5f0f\u6709\u8bef!", (String)"DptRevenueImportPlugin_11", (String)"tmc-cim-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
                        errorInfo.append(importTip).append("\n");
                    }
                }
            }
            catch (KDBizException bizExp) {
                this.getModel().deleteEntryRow(entryProp, rowIndex);
                tips = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s", (String)"DptRevenueImportPlugin_6", (String)"tmc-cim-formplugin", (Object[])new Object[0]), row.get("excelrow"), bizExp.getMessage());
                errorInfo.append(tips).append("\n");
                logger.info("EntryImport >> data >> " + (Object)((Object)bizExp));
            }
            catch (Exception e) {
                this.getModel().deleteEntryRow(entryProp, rowIndex);
                tips = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s", (String)"DptRevenueImportPlugin_6", (String)"tmc-cim-formplugin", (Object[])new Object[0]), row.get("excelrow"), e.getMessage());
                errorInfo.append(tips).append("\n");
                logger.info("EntryImport >> data >> " + e.getMessage());
            }
        }
        if (EmptyUtil.isNoEmpty((String)errorInfo.toString())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u6570\u636e\u5bfc\u5165\u5f02\u5e38\u3002\u8bf7\u70b9\u51fb\u201c\u5c55\u793a\u8be6\u60c5\u201d\u67e5\u770b\u3002", (String)"DptRevenueImportPlugin_12", (String)"tmc-cim-formplugin", (Object[])new Object[0]), errorInfo.toString(), MessageTypes.Default);
        }
        this.getModel().endInit();
        this.getView().updateView(entryProp);
    }
}

