/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.dptrevenue;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.cim.formplugin.intbatch.AbstractNavigateAddPlugin;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenueNavigatePlugin
extends AbstractNavigateAddPlugin {
    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map paraMap = showParameter.getCustomParams();
        Object depositId = paraMap.get("loanbill");
        if (EmptyUtil.isEmpty(depositId)) {
            return;
        }
        DynamicObject depositBill = TmcDataServiceHelper.loadSingle(depositId, (String)"cim_deposit");
        DynamicObject org = depositBill.getDynamicObject("org");
        DynamicObjectCollection companyColls = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"company", (DynamicObject[])new DynamicObject[]{org});
        this.getModel().setValue("company", (Object)companyColls);
        DynamicObject currency = depositBill.getDynamicObject("currency");
        DynamicObjectCollection currencyColls = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"currency", (DynamicObject[])new DynamicObject[]{currency});
        this.getModel().setValue("currency", (Object)currencyColls);
        this.getModel().setValue("finbillno", (Object)depositBill.getString("billno"));
        IListView parentView = (IListView)this.getView().getParentView();
        String formId = parentView.getBillFormId();
        if (formId.startsWith("ifm_")) {
            this.getModel().setValue("settlecenter", (Object)depositBill.getDynamicObject("finorginfo"));
        } else {
            boolean isSettleCenter = DepositHelper.isSettleCenterBill((DynamicObject)depositBill);
            this.getModel().setValue("settlecenterdpt", (Object)isSettleCenter);
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"company", "settlecenter", "settlecenterdpt", "currency", "finbillno"});
        List<Object> depositIds = Collections.singletonList(depositBill.getPkValue());
        this.getPageCache().put("finbill", SerializationUtils.toJsonString(depositIds));
    }

    @Override
    protected String chooseOpenFinBillId() {
        String entityId = this.getView().getEntityId();
        if (StringUtils.equals((CharSequence)entityId, (CharSequence)"cim_dptrevenue_navigate")) {
            return "cim_deposit";
        }
        return "ifm_deposit";
    }

    @Override
    protected String chooseBatchPreFormId() {
        return "cim_dptrevenuebatch";
    }

    @Override
    protected Date getStartIntDate(DynamicObject finBill) {
        return DepositHelper.getIntCalcStartDate((DynamicObject)finBill);
    }

    @Override
    protected String getFunction() {
        return "getint";
    }

    @Override
    protected QFilter setOpenFinBillFilter() {
        List<String> finStatus = Arrays.asList(FinServiceStatusEnum.subscribe_done.getValue(), FinServiceStatusEnum.subscribe_part.getValue(), FinServiceStatusEnum.subscribe_norevenue.getValue());
        QFilter qFilter = new QFilter("bizstatus", "in", finStatus);
        qFilter.and(new QFilter("isresubmit", "!=", (Object)Boolean.TRUE));
        QFilter offChannelFilter = new QFilter("tradechannel", "!=", (Object)TradeChannelEnum.ONLINE.getValue());
        QFilter tradeChannleFilter = offChannelFilter.or(new QFilter("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue()).and(new QFilter("bebankstatus", "=", (Object)BebankStatusEnum.TS.getValue())));
        qFilter.and(tradeChannleFilter);
        DynamicObjectCollection company = (DynamicObjectCollection)this.getModel().getValue("company");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)company)) {
            Set companyIds = company.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
            qFilter.and("org", "in", companyIds);
        } else {
            String appId = this.getView().getFormShowParameter().getAppId();
            String currentEntity = StringUtils.equals((CharSequence)"cim", (CharSequence)appId) ? "cim_dptrevenuebatch" : "ifm_dptrevenuebatch";
            List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)currentEntity, (String)"47150e89000000ac");
            qFilter.and("org", "in", (Object)comIdList);
        }
        DynamicObjectCollection currency = (DynamicObjectCollection)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currency)) {
            Set ids = currency.stream().map(c -> c.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            qFilter.and("currency", "in", ids);
        }
        Date endIntDate = (Date)this.getModel().getValue("endintdate");
        qFilter.and(QFilter.isNotNull((String)"lastrevenuedate").and("lastrevenuedate", "<", (Object)DateUtils.getLastDay((Date)endIntDate, (int)1)).or(QFilter.isNull((String)"lastrevenuedate").and("intdate", "<=", (Object)DateUtils.getLastDay((Date)endIntDate, (int)1))));
        this.addSettleCenterFilter(qFilter);
        Object loanIds = this.getView().getFormShowParameter().getCustomParams().get("loanIds");
        if (EmptyUtil.isNoEmpty(loanIds)) {
            qFilter.and("id", "not in", loanIds);
        }
        return qFilter;
    }

    private void addSettleCenterFilter(QFilter qFilter) {
        boolean containSettleCenter = (Boolean)this.getModel().getValue("settlecenterdpt");
        String compareStr = containSettleCenter ? "=" : "!=";
        qFilter.and(new QFilter("finorginfo.finorgtype.type", compareStr, (Object)"1"));
        DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("settlecenter");
        if (EmptyUtil.isNoEmpty((DynamicObject)settleCenter)) {
            qFilter.and(new QFilter("finorginfo", "=", settleCenter.getPkValue()));
        }
    }
}

