/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.finbase;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.cim.formplugin.resource.CimFormResourceEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class RedeemRevenueBaseList
extends AbstractTmcListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        String entityName = billList.getEntityId();
        if (CimEntityEnum.cim_redeem.getValue().equals(entityName)) {
            args.setListDataProvider((IListDataProvider)new ListDataProvider(){

                public DynamicObjectCollection getData(int arg0, int arg1) {
                    DynamicObjectCollection rows = super.getData(arg0, arg1);
                    if (rows.isEmpty()) {
                        return rows;
                    }
                    DataEntityPropertyCollection properties = rows.getDynamicObjectType().getProperties();
                    if (!properties.containsKey((Object)"redeempattern") || !properties.containsKey((Object)"redeempatternstr")) {
                        return rows;
                    }
                    for (DynamicObject row : rows) {
                        int redeemPattern = row.getInt("redeempattern");
                        row.set("redeempatternstr", (Object)("T + " + redeemPattern));
                    }
                    return rows;
                }
            });
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.removeSpareFilter(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        String clearExpireDate = (String)this.getView().getFormShowParameter().getCustomParam("clearExpireDate");
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!"org.name".equals(fieldName) && (!"true".equals(clearExpireDate) || !"expiredate".equals(fieldName))) continue;
            commonFilter.setDefaultValue("");
        }
    }

    public void setFilter(SetFilterEvent e) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        String entityName = billList.getEntityId();
        if (CimEntityEnum.cim_revenue.getValue().equals(entityName)) {
            e.getQFilters().add(new QFilter("datasource", "=", (Object)"revenue"));
        } else if ("cim_intbill_revenue".equals(entityName)) {
            e.getQFilters().add(new QFilter("datasource", "=", (Object)"interestrev"));
        }
        e.getQFilters().add(new QFilter("id", "not in", this.getPreIntIds()));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "linkquery": 
            case "unredwriteoff": {
                Long billPkId = this.getSelectedId();
                if (!EmptyUtil.isEmpty((Long)billPkId)) break;
                args.setCancel(true);
                return;
            }
            case "pushrec": {
                if (!CimEntityEnum.cim_redeem.getValue().equals(this.getBillFormId()) || this.checkCanPushRevenueBill()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean checkCanPushRevenueBill() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject redeem = TmcDataServiceHelper.loadSingle((Object)id, (String)CimEntityEnum.cim_redeem.getValue(), (String)"bebankstatus,tradechannel");
        String tradeChannel = redeem.getString("tradechannel");
        if (TradeChannelEnum.ONLINE.getValue().equals(tradeChannel) && !"TS".equals(redeem.getString("bebankstatus"))) {
            this.getView().showTipNotification(CimFormResourceEnum.RedeemRevenueBaseList_2.loadKDString());
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (EmptyUtil.isEmpty((Object)operationResult) || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "redwriteoff": 
            case "unredwriteoff": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "linkquery": {
                this.showLinkForm(args);
                break;
            }
        }
    }

    private void removeSpareFilter(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        commonFilterColumns.removeIf(v -> StringUtils.equalsAny((String)v.getFieldName(), (String[])new String[]{"finorginfo.name", "bebankstatus", "submittime"}));
        args.getFastFilterColumns().removeIf(v -> StringUtils.equalsAny((String)v.getFieldName(), (String[])new String[]{"finorginfo.name"}));
    }

    private Set<Long> getPreIntIds() {
        DynamicObjectCollection intbillentries = QueryServiceHelper.query((String)"cim_intbill_batch", (String)"entry.intbillid", (QFilter[])new QFilter[]{new QFilter("billstatus", "in", (Object)new String[]{"A", "B"}), new QFilter("entry.intbillid", "!=", (Object)0L)});
        DynamicObjectCollection intbills = QueryServiceHelper.query((String)"cim_intbill_revenue", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)intbillentries.stream().map(o -> o.get("entry.intbillid")).toArray()), new QFilter("billstatus", "=", (Object)"B")});
        HashSet<Long> intIds = new HashSet<Long>();
        intbills.stream().forEach(item -> intIds.add(item.getLong("id")));
        intIds.remove(0L);
        return intIds;
    }

    private void showLinkForm(AfterDoOperationEventArgs args) {
        BillShowParameter showParameter = new BillShowParameter();
        String currentFormId = ((ListView)this.getView()).getBillFormId();
        String openFormId = "cim_redeem".equals(currentFormId) ? "cim_revenue" : "cim_redeem";
        showParameter.setFormId(openFormId);
        Object downStreamId = this.getLinkBillId(args, currentFormId);
        if (EmptyUtil.isEmpty((Object)downStreamId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"RedeemRevenueBaseList_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return;
        }
        showParameter.setPkId(downStreamId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Object getLinkBillId(AfterDoOperationEventArgs args, String currentFormId) {
        List successPkIds = args.getOperationResult().getSuccessPkIds();
        if ("cim_redeem".equals(currentFormId)) {
            QFilter qFilter = new QFilter("redeemid", "=", successPkIds.get(0));
            List downStreamIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_revenue", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
            return EmptyUtil.isEmpty((Collection)downStreamIds) ? Long.valueOf(0L) : downStreamIds.get(0);
        }
        DynamicObjectCollection revCols = QueryServiceHelper.query((String)"cim_revenue", (String)"redeemid", (QFilter[])new QFilter[]{new QFilter("id", "=", successPkIds.get(0))});
        return ((DynamicObject)revCols.get(0)).getLong("redeemid");
    }
}

