/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.finsubscribe;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.helper.RevenueCalcHelper;
import kd.tmc.cim.common.helper.RevenuePlanCalHelper;
import kd.tmc.cim.formplugin.finsubscribe.FinSubscribeFormHelper;
import kd.tmc.cim.formplugin.resource.CimFormResourceEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class FinSubscribeRevePlanPlugin
extends AbstractBasePlugIn {
    private static final String HANDREVENUEPLAN_CALLBACKID = "handRevenuePlan_callBackId";
    private static final String HANDREVENUEPLAN_CALLBACKID_HAND = "handRevenuePlan_callBackId_calreveplan";
    private static final String ISPASS_VOID = "ispassVoid";

    public void registerListener(EventObject e) {
        TextEdit finBillNumber = (TextEdit)this.getControl("finsubscribe");
        if (EmptyUtil.isNoEmpty((Object)finBillNumber)) {
            finBillNumber.addClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"finsubscribe", null);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (OperationStatus.ADDNEW != this.getView().getFormShowParameter().getStatus()) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"finsubscribe", (Object)this.getModel().getValue("billno"));
        }
        this.setCanEditByIntState();
    }

    private void showConfirmTip(String flag) {
        this.getView().showConfirm(CimFormResourceEnum.FinSubscribeIntPlanPlugin_1.loadKDString(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(String.format("%s_%s", HANDREVENUEPLAN_CALLBACKID, flag), (IFormPlugin)this));
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        int rowIndex = e.getRowIndex();
        Object value = e.getValue();
        switch (key) {
            case "handreveplan": {
                this.handinstPlanBeforePost(e, rowIndex, (Boolean)value);
                break;
            }
            case "revenuedate": {
                this.interestBeforePost(e, rowIndex, value);
                break;
            }
        }
    }

    private void interestBeforePost(BeforeFieldPostBackEvent e, int rowIndex, Object value) {
        DynamicObjectCollection entrys;
        Set<Date> dateSet;
        String error;
        Date revenueDate = null;
        if (value != null) {
            String dateFormat = ((DateEdit)this.getControl("revenuedate")).getFormatString();
            revenueDate = DateUtils.stringToDate((String)value.toString(), (String)dateFormat);
        }
        if (EmptyUtil.isNotEmpty((CharSequence)(error = this.checkRevenueDate(dateSet = (entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("revenue_entry")).stream().map(i -> i.getDate("revenuedate")).collect(Collectors.toSet()), revenueDate)))) {
            e.setCancel(true);
            this.getView().showErrorNotification(error);
            this.getView().updateView("revenuedate", rowIndex);
        }
    }

    private void handinstPlanBeforePost(BeforeFieldPostBackEvent e, int rowIndex, boolean isHandin) {
        if (isHandin && !this.checkIsSelectFinSubsribe()) {
            e.setCancel(true);
            this.getView().updateView("handreveplan", rowIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "handRevenuePlan_callBackId_calreveplan": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue(ISPASS_VOID, "true");
                    this.getView().invokeOperation("calreveplan", option);
                    break;
                }
                this.getModel().setValue("handreveplan", (Object)Boolean.TRUE);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        Object source = evt.getSource();
        if (!(source instanceof Control)) {
            return;
        }
        switch (key = ((Control)source).getKey()) {
            case "finsubscribe": {
                this.openfinBill();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "calreveplan": {
                this.beforeCalrevePlanOp(args, formOperate, operateKey);
                break;
            }
            case "savereveplan": {
                this.beforeSaveOp(args);
                break;
            }
        }
    }

    private void beforeSaveOp(BeforeDoOperationEventArgs args) {
        if (!this.checkIsSelectFinSubsribe()) {
            args.setCancel(true);
            return;
        }
        DynamicObject finSubBill = this.getModel().getDataEntity(true);
        DynamicObjectCollection entrys = finSubBill.getDynamicObjectCollection("revenue_entry");
        if (!this.checkEntrys(entrys)) {
            args.setCancel(true);
        }
    }

    private void beforeCalrevePlanOp(BeforeDoOperationEventArgs args, FormOperate formOperate, String operateKey) {
        if (this.checkIsSelectFinSubsribe()) {
            Boolean isHandinstPlan = (Boolean)this.getModel().getValue("handreveplan");
            if (!"true".equals(formOperate.getOption().getVariableValue(ISPASS_VOID, "")) && !isHandinstPlan.booleanValue()) {
                this.showConfirmTip(operateKey);
                args.setCancel(true);
            }
        } else {
            args.setCancel(true);
        }
    }

    private boolean checkIsSelectFinSubsribe() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("finsubscribe"))) {
            this.getView().showErrorNotification(CimFormResourceEnum.FinSubscribeIntPlanPlugin_4.loadKDString());
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "savereveplan": {
                this.getView().invokeOperation("refresh");
                this.getModel().setDataChanged(false);
                break;
            }
            case "calreveplan": {
                Boolean isHandinstPlan = (Boolean)this.getModel().getValue("handreveplan");
                this.calIntByPlan(isHandinstPlan);
                this.setCanEditByIntState();
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if ("revenue_entry".equals(entryName)) {
            for (int rowIndex : e.getRowIndexs()) {
                String repayState = (String)this.getModel().getValue("revenuestate", rowIndex);
                if (!"1".equals(repayState)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u76ca\u72b6\u6001\u4e3a\u201c\u5df2\u6267\u884c\u201d\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DptRevenuePlanEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    private void calIntByPlan(boolean isHand) {
        Pair<BigDecimal, List<IntBillInfo>> intBills;
        IDataModel model = this.getModel();
        DynamicObject finBill = this.getModel().getDataEntity(true);
        if (isHand) {
            DynamicObjectCollection entrys = finBill.getDynamicObjectCollection("revenue_entry");
            if (!this.checkEntrys(entrys)) {
                return;
            }
            intBills = this.callIntPlanByHand(finBill, entrys);
            if (intBills == null) {
                return;
            }
        } else {
            intBills = RevenueCalcHelper.callIntPlan((DynamicObject)finBill);
        }
        RevenuePlanCalHelper.finBillWriteBack((Pair)intBills, (DynamicObject)model.getDataEntity());
        this.getView().updateView("revenue_entry");
    }

    private Pair<BigDecimal, List<IntBillInfo>> callIntPlanByHand(DynamicObject finBill, DynamicObjectCollection entrys) {
        entrys.sort(Comparator.comparing(e -> e.getDate("revenuedate")));
        ArrayList<PlanCallResult> intPlanList = new ArrayList<PlanCallResult>(entrys.size());
        for (DynamicObject entry : entrys) {
            if (entry.getInt("revenuestate") == 1) continue;
            PlanCallResult callResult = new PlanCallResult();
            Date revenueDate = entry.getDate("revenuedate");
            if (EmptyUtil.isEmpty((Object)revenueDate)) continue;
            callResult.setBizDate(revenueDate);
            intPlanList.add(callResult);
        }
        return RevenueCalcHelper.callIntPlanByHand((DynamicObject)finBill, intPlanList);
    }

    private boolean checkEntrys(DynamicObjectCollection entrys) {
        HashSet<Date> dateSet = new HashSet<Date>(8);
        StringBuilder errors = new StringBuilder();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            StringBuilder rowErrors = new StringBuilder();
            DynamicObject entry = (DynamicObject)entrys.get(i);
            if (1 == entry.getInt("revenuestate")) continue;
            String error = this.checkRevenueDate(dateSet, entry.getDate("revenuedate"));
            if (EmptyUtil.isNoEmpty((String)error)) {
                rowErrors.append(";").append(error);
            }
            if (rowErrors.length() <= 0) continue;
            errors.append(CimFormResourceEnum.FinSubscribeImportPlugin_5.loadKDString(i + 1, rowErrors.toString())).append("\n");
        }
        if (errors.length() > 0) {
            this.getView().showErrorNotification(errors.toString());
            return false;
        }
        return true;
    }

    private String checkRevenueDate(Set<Date> dateSet, Date revenueDate) {
        if (EmptyUtil.isEmpty((Object)revenueDate)) {
            return CimFormResourceEnum.FinSubscribeIntPlanPlugin_5.loadKDString();
        }
        if (!dateSet.add(revenueDate)) {
            return CimFormResourceEnum.FinSubscribeImportPlugin_7.loadKDString();
        }
        return FinSubscribeFormHelper.checkRevePlanRevenueDate(this.getModel(), revenueDate, "yyyy-MM-dd");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if ("finsubscribe".equals(e.getActionId()) && EmptyUtil.isNoEmpty((Object)returnData)) {
            Object id = ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue();
            ((IBillModel)this.getModel()).load(id);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"finsubscribe", (Object)((ListSelectedRowCollection)returnData).get(0).getBillNo());
            this.getView().updateView();
        }
    }

    private void openfinBill() {
        List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("org", "in", (Object)orgIds);
        qFilter.and("finservicestatus", "!=", (Object)FinServiceStatusEnum.subscribe_end.getValue());
        ListShowParameter paramter = ShowFormHelper.createShowListForm((String)"cim_finsubscribe", (boolean)false, (int)0, (boolean)true);
        paramter.getListFilterParameter().getQFilters().add(qFilter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "finsubscribe");
        paramter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)paramter);
    }

    private void setCanEditByIntState() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("revenue_entry");
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject repayPlan = (DynamicObject)entrys.get(i);
            if (repayPlan.getInt("revenuestate") != 1) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"revenuedate", "revenuecalamount", "revenueremark"});
        }
    }
}

