/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.finsubscribe;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcBotpHelper;

public class RedeemRevenueTabEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList redeemBillList = (BillList)this.getControl("redeembilllistap");
        if (OperationStatus.ADDNEW != this.getView().getFormShowParameter().getStatus() && redeemBillList != null) {
            redeemBillList.addHyperClickListener((HyperLinkClickListener)this);
            QFilter qFilter = this.getQFilter();
            redeemBillList.addSetFilterListener(setFilterEvent -> setFilterEvent.getQFilters().add(qFilter));
        }
        BillList revenueBillList = (BillList)this.getControl("revenuebilllistap");
        if (OperationStatus.ADDNEW != this.getView().getFormShowParameter().getStatus() && revenueBillList != null) {
            revenueBillList.addHyperClickListener((HyperLinkClickListener)this);
            QFilter qFilter = this.getQFilter();
            revenueBillList.addSetFilterListener(setFilterEvent -> setFilterEvent.getQFilters().add(qFilter));
        }
    }

    private QFilter getQFilter() {
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
            return new QFilter("billstatus", "=", (Object)"null");
        }
        Long finPkId = (Long)this.getModel().getValue("id");
        return new QFilter("finbillno", "=", (Object)finPkId);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTabListFilter();
    }

    private void initTabListFilter() {
        QFilter qFilter = this.getQFilter();
        BillList redeemBillList = (BillList)this.getControl("redeembilllistap");
        this.setBillListFilter(redeemBillList, qFilter);
        BillList revenueBillList = (BillList)this.getControl("revenuebilllistap");
        this.setBillListFilter(revenueBillList, qFilter);
    }

    private void setBillListFilter(BillList billList, QFilter qFilter) {
        if (billList != null) {
            billList.getFilterParameter().getQFilters().add(qFilter);
            billList.refreshData();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "billno": {
                this.openBillPage(evt);
                break;
            }
            case "recbillno": {
                BillList sourceBill = (BillList)evt.getSource();
                Long focusRowPkId = (Long)sourceBill.getFocusRowPkId();
                String formId = sourceBill.getEntityId();
                TmcBotpHelper.showBillParamter((String)formId, (Long)focusRowPkId, (IFormView)this.getView(), (String)"cas_recbill");
            }
        }
    }

    private void openBillPage(HyperLinkClickEvent evt) {
        BillList sourceBill = (BillList)evt.getSource();
        String formId = sourceBill.getEntityId();
        Object pkId = sourceBill.getFocusRowPkId();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.setPkId(pkId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

